Vue.component('v-multiselect', window.VueMultiselect.default);
Vue.http.options.emulateJSON = true;

var appPricer = new Vue({
    el: "#price-section",
    data: {
        rmtUrl: baseUrl,
        baseUrl: baseUrl,

        //v-multiselect variables
        destination_loading: false,
        destination_model: "",
        destination_options: [],

        //destination form variables
        plans_array: [],
        selected_plan: "",

        rooms_array: [],
        stay: moment().format("DD/MM/YYYY") + " - " + moment().add(3, 'days').format("DD/MM/YYYY"),
        stay_array: {
            start: moment().format("DD/MM/YYYY"),
            end: moment().add(3, 'days').format("DD/MM/YYYY"),
        },
        total_guests: "2 adultos, 0 menor(es)",
        nacionalidad: nacionalidad,
        //DOM variables
        show_dropdown_rooms: false,
        children_age_options: [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17],
        model_paises: false,
    },
    created: function() {
        this.loadPlans();
        this.initFormOptions();
    },
    methods: {
        loadPlans: function() {
            var url_plan = this.rmtUrl + '/plan/filtros'
            this.$http.get(encodeURI(url_plan)).then(function (response) {
                this.plans_array = response.body.plan;
            }, function () {
                console.log('Error');
            });
        },
        getRates: function() {
            var destination = "", url = "";
            if (this.destination_model.Tipo) {
                switch (this.destination_model.Tipo) {
                    case "Hotel":
                        destination = "h_" + this.destination_model.Codigo.replace("h_", "");
                        break;

                    case "Destino":
                        destination = "d_" + this.destination_model.Codigo.replace("d_", "");
                        break;

                    case "Zona":
                        destination = "z_" + this.destination_model.Codigo.replace("z_", "");
                        break;
                }
            } else {
                destination = this.destination_model.Codigo;
            }

            url = '?&filtro_disponibilidad=1&destino=' + destination + '&fecha_entrada=' + this.stay_array.start + '&fecha_salida=' + this.stay_array.end + '&habs=' + this.rooms_array.length + '&nacionalidad=' + this.nacionalidad;
            if (this.selected_plan != "") {
                url += "&plan=" + this.selected_plan
            }

            this.rooms_array.forEach((habitacion, index) => {
                url += '&habitacion_' + (index + 1) + '[adultos]=' + habitacion.num_adultos;
                url += '&habitacion_' + (index + 1) + '[num_ninios]=' + habitacion.num_menores;
                habitacion.edad_menores.forEach(menor => {
                    url += '&habitacion_' + (index + 1) + '[edad_' + menor.no_menor + ']=' + menor.edad;
                })
            });
            
            window.location.href = url;
        },
        getDestinations: function(query) {
            this.initOptionsHotels();
            if (query.length >= 3) {
                this.isLoading = true;
                this.$http.post(this.baseUrl + '/busqueda/SearchDestinations', {
                    search: query,
                    paises: this.model_paises
                }, {
                    before(request) {
                        // abort previous request, if exists
                        if (this.previousRequest) {
                            this.previousRequest.abort();
                        }
                        // set previous request on Vue instance
                        this.previousRequest = request;
                    }
                }).then(function (response) {
                    var response_var = response.body;
                    var array_destinos = response_var;
                    var that = this;
                    array_destinos.forEach(function (element) {
                        switch (element.Tipo) {
                            case "Destino":
                                that.destination_options[0].opciones.push(element);
                                break;

                            case "Zona":
                                that.destination_options[1].opciones.push(element);
                                break;

                            case "Hotel":
                                that.destination_options[2].opciones.push(element);
                                break;

                            case "Cadena":
                                that.destination_options[3].opciones.push(element);
                                break;

                            case "Extranet":
                                that.options[0].opciones.push(element);
                                break;
                        }
                    });
                    // console.log(that.options);
                    if (this.limit_options == 20) this.limit_options = 30;
                    this.isLoading = false;
                }, function (response) {
                    // console.log('Error' + JSON.stringify(response));
                });
            }
        },
        setDestinationModel: function(selectedOption, id) {
            var destino;
            switch(selectedOption.Tipo) {
                case "Hotel":
                    destino = "h_" + selectedOption.Codigo;
                    break;

                case "Destino":
                    destino = "d_" + selectedOption.Codigo;
                    break;

                case "Zona":
                    destino = "z_" + selectedOption.Codigo;
                    break;
            }
            $("#destino_hotels").val(destino);

            sessionStorage.setItem("paisVal", "MX");
            sessionStorage.setItem("paisText", "México");
            sessionStorage.setItem("destinoText", selectedOption.Nombre);
            sessionStorage.setItem("destinoVal", destino);
            sessionStorage.setItem("tituloDestino", selectedOption.Nombre);
        },
        initOptionsHotels: function() {
            this.destination_options = [];
            this.destination_options.push({
                tipo_destino: "Destinos",
                opciones: [],
            });

            this.destination_options.push({
                tipo_destino: "Zonas",
                opciones: [],
            });

            this.destination_options.push({
                tipo_destino: "Hoteles",
                opciones: [],
            });
            this.destination_options.push({
                tipo_destino: "Cadenas",
                opciones: [],
            });
        },
        addRoom: function() {
            var rooms_number = this.rooms_array.length;
            if (rooms_number < 5) {
                this.rooms_array.push({
                    no_hab: rooms_number,
                    num_adultos: 2,
                    num_menores: 0,
                    edad_menores: []
                });
            }

            this.calculateTotalPax();
        },
        removeRoom: function(index) {
            this.rooms_array.splice(index, 1);
            this.calculateTotalPax();
        },
        opGuestRoom: function(op, type, index) {
            var that = this;
            switch (op) {
                case "add":
                    if (type == "adult") {
                        if (this.rooms_array[index].num_adultos < 8) {
                            this.rooms_array[index].num_adultos++;
                        }
                    } else {
                        if (this.rooms_array[index].num_menores < 5) {
                            this.rooms_array[index].num_menores++;
                            this.rooms_array[index].edad_menores.push({
                                edad: 0,
                                no_menor: that.rooms_array[index].num_menores
                            });
                        }
                    }
                    break;

                case "subs":
                    if (type == "adult") {
                        if (this.rooms_array[index].num_adultos > 1) {
                            this.rooms_array[index].num_adultos--;
                        }
                    } else {
                        if (this.rooms_array[index].num_menores > 0) {
                            this.rooms_array[index].num_menores--;
                            hab.edad_menores.pop();
                        }
                    }
                    break;
            }
            this.calculateTotalPax();
        },
        initFormOptions: function () {
            var that = this;
            //this.destination_options = JSON.parse(localStorage.getItem("options_hoteles"));
            params = (new URL(document.location)).searchParams;
            var num_habs = parseInt(params.get("habs"));
            for (var i = 1; i <= parseInt(num_habs); i++) {
                var item_adults = params.getAll("habitacion_" + i + "[adultos]");
                var item_children = params.getAll("habitacion_" + i + "[num_ninios]");
                var adults = item_adults[0];
                var children = item_children[0];
                that.rooms_array.push({
                    no_hab: i,
                    num_adultos: parseInt(adults),
                    num_menores: parseInt(children),
                    edad_menores: [],
                });

                if(parseInt(children) > 0) {
                    for (var j = 1; j <= parseInt(children); j++) {
                        var item_children_ages = params.getAll("habitacion_" + i + "[edad_" + j + "]");
                        var children_age = item_children_ages[0];
                        that.rooms_array[i - 1].edad_menores.push({
                            edad: children_age,
                            no_menor: j,
                        });
                    }
                }
            }
            this.calculateTotalPax();

            var start_date = params.get('fecha_entrada');
            var end_date = params.get('fecha_salida');
            this.stay = start_date + " - " + end_date;
            this.stay_array.start = start_date;
            this.stay_array.end = end_date;

            var destination_model = {
                Codigo: "",
                Nombre: "",
                Destino: ""
            }
            var destination_type = params.get('destino');
            var type = destination_type.split('_');

            destination_model.Codigo = destination_type;
            destination_model.Nombre = $("#filter_url_name_destino").val();
            switch(type[0]) {
                case "h":
                    destination_model.Destino = 'Hotel';
                    break;

                case "d":
                    destination_model.Destino = 'Destino';
                    break;

                case "z":
                    destination_model.Destino = 'Zona';
                    break;
            }
            this.destination_model = destination_model;
            $("#destino_hotels").val(destination_model.Codigo);
        },
        calculateTotalPax: function() {
            var total_adults = 0;
            var total_children = 0;
            this.rooms_array.forEach((element) => {
                total_adults += element.num_adultos;
                if (element.num_menores > 0) {
                    total_children += element.num_menores;
                }
            });
            this.total_guests = total_adults + " adultos, " + total_children + " menor(es).";
        },
        showDropdownRooms: function() {
            this.show_dropdown_rooms = !this.show_dropdown_rooms;
        }
    }
});

var settings_dp = {
    format: 'DD/MM/YYYY',
    startOfWeek: 'sunday',
    i18n: {
        night: 'Noche',
        nights: 'Noches',
        button: 'Cerrar',
        'day-names-short': ['Dom', 'Lun', 'Mar', 'Mie', 'Jue', 'Vie', 'Sab'],
        'day-names': ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
        'month-names-short': ['Ene', 'Feb', 'Mar', 'Abr', 'Mar', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
        'month-names': ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        'info-more': 'Por favor seleccione la fecha de su estancia'
    },
    moveBothMonths: true
};
var dp_stay = document.getElementById('dp-stay');
var datepicker_hotels = new HotelDatepicker(dp_stay, settings_dp);

dp_stay.addEventListener('afterClose', function () {
    appPricer.stay = $("#dp-stay").val();
    var range = appPricer.stay.split("-");
    appPricer.stay_array.start = range[0].replace(/\s/g, "");
    appPricer.stay_array.end = range[1].replace(/\s/g, "");
}, false);

function getParameterByName(name) {
    name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
    var regex = new RegExp("[\\?&amp;amp;]" + name + "=([^&amp;amp;#]*)"),
        results = regex.exec(location.search);
    return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
};