var appExchange = new Vue({
    el: "#formularioReservar",
    data: {
        currency: localStorage.currency == undefined ? "OR" : localStorage.currency,
        // exchange: tasa_cambio_tarifa,
        exchange: exchange,
        exchange_rates: {
            usd: {
                purchase: exchange_rates.compra,
                sale: exchange_rates.importe,
            },
            cop: {
                purchase: exchange_rates.cop_compra,
                sale: exchange_rates.cop_venta,
            }
        },
        rate_currency: "MXN",
        rate_total: 0,
    },
    created: function() {
        this.formatter = new Intl.NumberFormat('en-US', {
            style: 'currency',
            currency: 'USD',
        });

        var total_array = (document.getElementById("lbl_total").textContent).split(" ");
        this.rate_total = Number(total_array[1].replace(/[^0-9.-]+/g,""));
        this.rate_currency = total_array[2];
    },
    mounted: function() {
        // this.printTotalExchange();
    },
    methods: {
        printTotalExchange: function() {
            var new_price = 0;
            if(this.currency != "OR" && typeof this.currency != "undefined") {
                console.log("if");
                if(this.currency == "USD" && this.rate_currency == "MXN") {
                    if (this.exchange != "") {
                        new_price = this.rate_total / parseFloat(this.exchange);
                    } else {
                        new_price = this.rate_total / this.exchange_rates.usd.purchase;
                    }
                } else if(this.currency == "MXN" && this.rate_currency == "USD") {
                    if (this.exchange != "") {
                        new_price = this.rate_total * parseFloat(this.exchange);
                    } else {
                        new_price = this.rate_total * this.exchange_rates.usd.sale;
                    }
                } else if(this.currency == "COP") {
                    if(this.rate_currency == "USD") {
                        if (this.exchange != "") {
                            new_price = this.rate_total * parseFloat(this.exchange);
                            new_price = new_price / this.exchange_rates.cop.purchase;
                        } else {
                            new_price = this.rate_total * this.exchange_rates.usd.sale;
                            new_price = new_price / this.exchange_rates.cop.purchase;
                        }
                    } else {
                        new_price = this.rate_total / this.exchange_rates.cop.purchase;
                    }
                }
            } else {
                if(this.rate_currency == "USD") {
                    if (this.exchange != "") {
                        new_price = this.rate_total * parseFloat(this.exchange);
                    } else {
                        new_price = this.rate_total * this.exchange_rates.usd.sale;
                    }
                } else {}
            }
            var new_currency = this.currency == "OR" ? "MXN" : this.currency;
            $("#total-exchange").append(this.formatter.format(new_price) + " " + new_currency);
            return new_price;
        }
    }
})