Vue.http.options.emulateJSON = true;
var appCarritoHeader = new Vue({
    el: '#plain',
    data: {
        array_carrito: [],
        rmt_url: baseUrl,
        urlsur4: urlsur4,
        loaded: false,
        language: language,
        currency: "OR",
        usd_venta: usd_venta,
        usd_compra: usd_compra,
        cop_venta: cop_venta,
        cop_compra: cop_compra,
        currency_options: ["MXN", "USD", "COP", "OR"],

        showing: false,
        // Anteriormente estaba en tarifas_vue
        markupAgencia: null,
        markupRmt: null,
        tipoTarifa: null
    },
    created: function() {
        this.verificaMarkup();
        // this.loadCarrito();
        this.currency = localStorage.getItem("currency") == null ? "OR" : localStorage.getItem("currency");
        

        this.getCurrency();
    },
    methods: {
        getCurrency: function() {
            this.$http.get(this.rmt_url + "/carrito/getCurrency").then(function(response) {
                if(localStorage.getItem("currency") != response.body.currency) {
                    this.changeCurrency(localStorage.getItem("currency") == null ? "OR" : localStorage.getItem("currency"));
                }

            }, function() {
                console.log('Error');
            });
        },
        changeCurrency: function(currency) {
            this.currency = currency;
            localStorage.setItem("currency", currency);
            $("#dropdown-menu-currency").removeClass("show");
            this.$http.post(this.rmt_url + "/carrito/changeCurrency", { currency: currency }).then(function(response) {
                if((window.location.pathname).includes("view")) {
                    window.location.reload();
                }

            }, function() {
                console.log('Error');
            });
        },
        
        loadCarrito: function() {
            /*var string_json = localStorage.getItem("shoopping_cart");
            this.array_carrito = JSON.parse(string_json);
            if(this.array_carrito == null) {
                this.array_carrito = [];
            }*/

            this.$http.get(this.rmt_url + "/carrito/getCarrito").then(function(response) {
                this.array_carrito = response.body;
                this.loaded = true;
            }, function() {
                console.log('Error');
            });
        },
        deleteItemCarrito: function(index) {
            this.array_carrito.splice(index, 1);
            /*localStorage.setItem("shoopping_cart", JSON.stringify(this.array_carrito));*/

            var post_data = { index: index };
            this.$http.post(this.rmt_url + "/carrito/deleteCarrito", post_data).then(function(response) {

            }, function() {
                console.log('Error');
            });
        },
        emptyCarrito: function() {
            this.array_carrito = [];
            localStorage.removeItem("info_agencia")

            this.$http.post(this.rmt_url + "/carrito/emptyCarrito").then(function(response) {

            }, function() {
                console.log('Error');
            });
        },
        verificaMarkup: function() {
            this.$http.get(this.rmt_url + '/agenciasMarkup/markup').then(function(response) {
                var response = response.body;
                localStorage.setItem("markup", JSON.stringify(response));
                if (response.markup != 0 && response.markup != null) {
                    this.markupAgencia = response.markup;
                }

                if (response.markupRmt != 0 && response.markupRmt != null) {
                    this.markupRmt = response.markupRmt;
                    this.tipoTarifa = response.tarifa;
                }
            }, function() {
                console.log('Error');
            });
        },
        aplicarMarkup(precio) {
            var new_price = precio;
            if (typeof localStorage.markup != "undefined") {
                // var valores = JSON.parse(localStorage.markup);
                var markup = this.markupAgencia;
                var markupRmt = this.markupRmt;
                new_price = this.convertToNumber(precio);
                new_price = parseFloat(new_price);
                if (markup != 0 && markup != null) {
                    markup = parseFloat(this.markupAgencia);
                    var ganancia = (100 - markup) / 100;
                    // var ganancia = new_price * (markup / 100);
                    new_price = new_price / ganancia;
                }

                if (markupRmt != 0 && markupRmt != null) {
                    markupRmt = parseFloat(this.markupRmt);
                    var gananciaRmt = (100 - markupRmt) / 100;
                    // var gananciaRmt = new_price * (markupRmt / 100);
                    new_price = new_price / gananciaRmt;
                }
            }

            return new_price;
        },
        printPrecio: function(precio, moneda, tasa_cambio = 0, show = 1) {
            new_price = this.aplicarMarkup(precio);
            if (moneda != this.currency) {
                if (moneda == "USD" && this.currency == "MXN") {
                    if (tasa_cambio > 1) {
                        new_price = new_price * this.convertToNumber(tasa_cambio);
                    } else {
                        new_price = new_price * this.usd_venta;
                    }
                } else if (moneda == "MXN" && this.currency == "USD") {
                    if (tasa_cambio > 1) {
                        new_price = new_price / this.convertToNumber(tasa_cambio);
                    } else {
                        new_price = new_price / this.usd_compra;
                    }
                } else if (moneda == "MXN" && appCarritoHeader.currency == "COP") {
                    /* if (tasa_cambio > 1) {
                        new_price = new_price / this.convertToNumber(tasa_cambio);
                    } else {
                    } */
                    new_price = new_price / appCarritoHeader.cop_compra;
                } else if (moneda == "USD" && appCarritoHeader.currency == "COP") {
                    if (tasa_cambio > 1) {
                        new_price = new_price * this.convertToNumber(tasa_cambio);
                        new_price = new_price / appCarritoHeader.cop_compra;
                    } else {
                        new_price = new_price * appCarritoHeader.usd_venta;
                        new_price = new_price / appCarritoHeader.cop_compra;
                    }
                }
            }

            if (show) {
                new_price = this.formatPrice(new_price);
            }
            return new_price;
        },
        printMoneda: function(moneda) {
            new_currency = moneda;
            if (moneda != this.currency) {
                if (this.currency == "MXN" && moneda == "USD") {
                    new_currency = "MXN";
                } else if (this.currency == "USD" && moneda == "MXN") {
                    new_currency = "USD";
                } else if (appCarritoHeader.currency == "COP" && (moneda == "MXN" || moneda == "USD")) {
                    new_currency = "COP";
                }
            }
            return new_currency;
        },
        getTotalCotiz: function(item, prov) {
            var that = this;
            var total = 0;
            var moneda = "";
            item.forEach(function(element) {
                if (prov == 3 || prov == 10) {
                    var monto = that.printPrecio(element.precio, element.moneda, 1, 0);
                    total += monto;
                    moneda = that.printMoneda(element.moneda);
                } else {
                    Object.values(element.calendario.habitacion).forEach(function(element_hab) {
                        var monto = that.printPrecio(element_hab.Total.total, element_hab.Total.moneda, element.tasa_cambio, 0);
                        total += monto;
                        moneda = that.printMoneda(element_hab.Total.moneda);
                    });
                }
            });
            return "$ " + this.formatPrice(total) + " " + moneda;
        },
        printTotalTour: function(item, info_search, descuentoTarifaMX) {
            var adults_price, children_price;
            var item_array = Object.values(item);
            var adults_price = item.desglose.filter(function(i) {
                return i.tipo === "Adulto";
            });
            var adult_price = adults_price[0];

            var total = (adult_price.precio * item.tasa_cambio) * parseInt(info_search.num_adultos);

            if (info_search.destino == 'c_8') total = adult_price.precio;

            if (parseInt(info_search.num_ninios) > 0) {
                var that = this;
                var array_menores = Object.values(info_search.num_edad);
                var children_price = item.desglose.filter(function(i) {
                    return i.tipo === "Menor";
                });
                if (children_price.length > 0) {
                    children_price.forEach(function(element, index) {
                        array_menores.forEach(function(element_edad) {
                            if (parseInt(element_edad) >= parseInt(element.edad_min) && parseInt(element_edad) <= parseInt(element.edad_max)) {
                                total += (element.precio * item.tasa_cambio);
                            } else if (parseInt(element_edad) > parseInt(adult_price.edad_min)) {
                                total += (adult_price.precio * item.tasa_cambio);
                            }
                        });
                    });
                } else {
                    array_menores.forEach(function(element) {
                        if (parseInt(element) >= parseInt(adult_price.edad_min) && parseInt(element) <= parseInt(adult_price.edad_max)) {
                            total += (adult_price.precio * item.tasa_cambio);
                        }
                    });
                }
            }

            if (descuentoTarifaMX == false) {
                total = this.round(total, 2);
            } else {
                var total_discount = total * 0.10;
                var total_net = total - total_discount;
                total = this.round(total_net, 2);
            }

            return total;
        },
        showModal: function() {
            $("#modal-busqueda").addClass("open");
            console.log("modal");
        },
        showCart: function() {
            // console.log(this.showing);
            // if(this.showing == false) {
            //     $("#cart_items").css('display', 'block');
            //     $("#cart_items").removeAttr('style');
            //     this.showing = true;
            //     console.log(this.showing);
            // } else {
            //     $("#cart_items").removeAttr('style');
            //     $("#cart_items").css('display', 'none');
            //     $("#cart_items").removeClass('show');
            //     this.showing = false;
            //     console.log(this.showing);
            // }
        },
        round: function(value, decimals) {
            return Number(Math.round(value + 'e' + decimals) + 'e-' + decimals).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
        },
        formatPrice(cant_dinero) {
            let val = (cant_dinero / 1).toFixed(2).replace(',', '.')
            return val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        },
        convertToNumber: function(numero) {
            if (typeof numero.replace(',', '') == undefined) {
                var number = numero;
            } else {
                var number = numero.replace(',', '');
            }
            return parseFloat(number);
        },
        printMonedaMenorTarifa: function(tarifas) {
            var moneda = tarifas.moneda
            if (tarifas.moneda == "USD" && parseInt(tarifas.tasa_cambio) > 1) {
                moneda = "MXN";
            }
            return moneda;
        }
    }
});

var appFooter = new Vue({
    el: '#lang',
    data: {},
    methods: {
        changeLanguage: function() {
            //this.$refs.form.submit();
            $("#lang").submit();
        },
    }
});

$('body').on('click', '.search-overlay-close', function(event) {
    $("#modal-busqueda").removeClass("open");
});

