var total_reserva = parseFloat($("#total_reserva").val());
var tasa_baseOP = 2.9 / 100;
var comision_baseOP = 2.5;
var impuestoIVA = 0.16;
var mensajeMontoPagar = document.getElementById("mensajeMontoPagar");
$(document).ready(function () {
  let sandboxMode = true;
  if (ambienteOpenpay == 1) {
    sandboxMode = false;
  }

  $("#abonoReserva").val(total_reserva.toFixed(2));

  let com_base = (total_reserva * tasa_baseOP) + comision_baseOP;
  let com_base_iva = com_base * impuestoIVA;
  let totalComision = total_reserva + (com_base + com_base_iva);
  let total_comisionado = totalComision.toFixed(2);

  mensajeMontoPagar.innerText = "El monto a pagar con la comisión será: ($"+total_comisionado+")";


  var msiOpenPay = false;
  var numMSIOpenPay = 0;
  OpenPay.setId(merchantId);
  OpenPay.setApiKey(publicKey);
  OpenPay.setSandboxMode(sandboxMode);
  deviceSessionId = OpenPay.deviceData.setup(
    "payment-form-openpay",
    "deviceIdHiddenFieldName"
  );
  $("#pay-button").on("click", function (event) {
    if (!validarFormulariosReservacion()) return false;
    if ($("#condiciones").is(":not(:checked)")) {
      Swal.fire({
        title: 'Advertencia',
        text: "Debe aceptar los términos y condiciones",
        icon: 'warning',
        showCancelButton: false,
      })
    } else {
      btnPayOpenpay(true);
      event.preventDefault();
      OpenPay.token.create({
        card_number: $("#card_number").val(),
        holder_name: $("#holder_name").val(),
        expiration_year: $("#expiration_year").val(),
        expiration_month: $("#expiration_month").val(),
        cvv2: $("#cvv2").val(),
      },
        success_callbak,
        error_callbak
      );
    }

    if (msiOpenPay) {
      numMSIOpenPay = $("#selectMSIOpenpay").val();
    } else {
      numMSIOpenPay = 0;
    }
  });
  var success_callbak = async function (response) {
    var token_id = response.data.id;
    $("#token_id").val(token_id);
    try {
      let req = await fetch(urlBase + "/pagos/openPay", {
        method: "POST",
        headers: {
          "Content-Type": "application/json"
        },
        body: JSON.stringify({
          token: token_id,
          agencia: agencia,
          deviceSessionId: deviceSessionId,
          name: $("#holder_name").val(),
          phone: $("#Reservacion_tel_cliente").val(),
          email: $("#Reservacion_email").val(),
          // total: $("#total_reserva").val(),
          total: $("#abonoReserva").val(),
          msi: numMSIOpenPay,
        }),
      }),
        res = await req.json();
      if (res.success) {
        localStorage.setItem("contformulario", JSON.stringify($("#reservacion-form").serializeArray()));
        let timerInterval
        Swal.fire({
          title: 'En un momento se redireccionará al proceso de autentificación de su banco.',
          html: '',
          timer: 5000,
          timerProgressBar: true,
          didOpen: () => {
            Swal.showLoading()
          },
        }).then((result) => {
          /* Read more about handling dismissals below */
          if (result.dismiss === Swal.DismissReason.timer) {
            console.log('I was closed by the timer')
          }
        })
        // Swal.fire('En un momento se redireccionará al proceso de autentificación de su banco', '', 'success');
        setTimeout(function () {
          window.location.href = res.url_autentificacion
        }, 5000);
        // crearreservacion();
        btnPayOpenpay(false);
        return true;
      } else {
        sweetError(res, res.message, false);
        btnPayOpenpay(false);
      }
    } catch (error) {
      console.error(error);
    }
  };
  var error_callbak = function (response) {
    var desc =
      response.data.description != undefined ?
        response.data.description :
        response.message;
    alert("ERROR [" + response.status + "] " + desc);
    btnPayOpenpay(false);
  };
  var btnPayOpenpay = function (status) {
    const btn = document.querySelector("#pay-button");
    if (status) {
      btn.disabled = true;
      btn.textContent = "Pagando...";
    } else {
      btn.disabled = false;
      btn.textContent = "Pagar";
    }
  };

  function validarFormulariosReservacion() {
    var mensaje = "";
    var response = true;
    // console.log('aqui')
    var reg = /(\.|\-)/g;

    var num_hab = $("#Reservacion_num_habitaciones").val();
    for (var hab = 1; hab <= num_hab; hab++) {
      var num_adultos = $("#num_adultos_" + hab).val();
      for (var i = 1; i <= num_adultos; i++) {
        if (
          $("#nombre_" + i + "_" + hab).val() == "" ||
          $("#apellido_" + i + "_" + hab).val() == ""
        ) {
          mensaje +=
            "El nombre y apellido de pasajero #" +
            i +
            " son requeridos en habitación:" +
            hab;
          response = false;
        }
        if (
          reg.test($("#nombre_" + i + "_" + hab).val()) == true ||
          reg.test($("#apellido_" + i + "_" + hab).val()) == true
        ) {
          mensaje +=
            "El nombre y/o apellido de pasajero #" +
            i +
            " contiene caracteres no permitidos. habitación:" +
            hab;
          response = false;
        }
      }
    }

    if (
      $("#s2_agencias").val() == "" ||
      $("#s2_agentes").val() == "" ||
      $("#nombre_cliente").val() == "" ||
      $("#apellido_cliente").val() == ""
    ) {
      console.log($("#s2_agencias").val());
      console.log($("#s2_agentes").val());
      console.log($("#s2_agentes").val());
      console.log($("#nombre_cliente").val());
      console.log($("#apellido_cliente").val());
      mensaje += "Por favor, complete los campos requeridos.";
      response = false;
    }

    if (
      reg.test($("#nombre_cliente").val()) == true ||
      reg.test($("#apellido_cliente").val()) == true
    ) {
      mensaje += "El nombre y/o apellido contiene caracteres no permitidos.";
      response = false;
    }

    if ($("#tel_cliente").val() == "" && $("#ok_elige_transporte").val() == 1) {
      mensaje += "Datos Adicionales para su transportación son requeridos.";
      response = false;
    }
    var xhr = {
      responseText: "Formulario Incompleto",
      status: "Advertencia",
      statusIcon: "warning",
    };
    if (response === false) {
      sweetError(xhr, mensaje, false);
    }
    return response;
  }



  $("#tarjetacredito").change(function (e) {
    e.preventDefault();
    msiOpenPay = this.checked;
    if (msiOpenPay) {
      $("#msiOpenpay").removeClass('d-none');
    } else {
      $("#msiOpenpay").addClass('d-none');
    }
  });
});

function personalizarMonto() {
  var inputSaldo = document.getElementById("abonoReserva");
  inputSaldo.removeAttribute("readonly");
  inputSaldo.focus();
  inputSaldo.select();
}

function reiniciarMonto() {
  // let total_reserva = parseFloat($("#total_reserva").val()).toFixed(2);
  var inputSaldo = document.getElementById("abonoReserva");
  inputSaldo.setAttribute("readonly", true);
  $("#abonoReserva").val(total_reserva.toFixed(2));

  let com_base = (total_reserva * tasa_baseOP) + comision_baseOP;
  let com_base_iva = com_base * impuestoIVA;
  let totalComision = total_reserva + (com_base + com_base_iva);
  let total_comisionado = totalComision.toFixed(2);

  mensajeMontoPagar.innerText = "El monto a pagar con la comisión será: ($"+total_comisionado+")";

}

function inputAbono(mensualidad = null) {
  let comision_meses= 0;
  if (mensualidad) {

    switch (mensualidad) {
			case '3':
				comision_meses = 4.8;
				break;
			case '6':
				comision_meses = 7.8;
				break;
			case '9':
				comision_meses = 10.8;
				break;
			case '12':
				comision_meses = 13.8;
				break;
			default:
				comision_meses = 0;
				break;
		}
  }
  
  // let total_reserva = parseFloat($("#total_reserva").val()).toFixed(2);
  let montoActual = parseFloat($("#abonoReserva").val());
  let montoMinimo = parseFloat(total_reserva / 2);
  let montoMaximo = parseFloat(total_reserva);

  let com_base = (montoActual * tasa_baseOP) + comision_baseOP;
  let tasa_meses = montoActual * (comision_meses / 100);
  let comision_iva = (com_base + tasa_meses) * impuestoIVA;
  let comision_openpay = com_base + tasa_meses + comision_iva;
  let total_comisionado = montoActual + comision_openpay;

  mensajeMontoPagar.innerText = "El monto a pagar con la comisión será: $"+total_comisionado.toFixed(2)+")";

  const mensajeDiv = document.getElementById("mensajeAdvertenciaMonto");

  if (montoActual < montoMinimo) {
    mensajeDiv.innerText = "El monto a pagar debe ser al menos el 50% del costo total. ($" + montoMinimo.toFixed(2) + ")";
    mensajeDiv.classList.remove("d-none");
  } else if (montoActual > montoMaximo) {
    mensajeDiv.innerText = "El monto a pagar debe ser menor al costo total. ($" + montoMaximo.toFixed(2) + ")";
    mensajeDiv.classList.remove("d-none");
  } else if (montoActual < 0 || montoActual == "") {
    $("#abonoReserva").val(montoMinimo.toFixed(2));
  } else {
    mensajeDiv.innerText = "";
    mensajeDiv.classList.add("d-none");
  }
}

function funcionPrueba() {
  console.log("test");
}