Vue.component('v-multiselect', window.VueMultiselect.default);
Vue.http.options.emulateJSON = true;

var appActivities = new Vue({
    el: '#activities_vue',
    data: {
        rmt_url: rmt_url,
        api_url: rmt_url + '/api/',
        loading: true,
        show: false,
        hdp: false,
        options_edad_menores: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17],

        //variables arreglos
        array_params: JSON.parse(array_params),
        cotiz_params: JSON.parse(array_params),
        array_activities: [],


        //variables globales y models
        url_activities: '',
        min_date: moment().format("DD/MM/YYYY"),

        selectDate: '',
        //models cotizador
        model_code: 0,
        model_destino: '',
        model_destinationcode: 0,
        model_code_destino: '',
        options_activities: [],
        model_rango_estancia: moment().format("DD/MM/YYYY") + " - " + moment().add(3, 'days').format("DD/MM/YYYY"),
        array_estancia: {
            fecha_entrada: moment().format("DD/MM/YYYY"),
            fecha_salida: moment().add(3, 'days').format("DD/MM/YYYY"),
        },

        isLoading: false,

        //filters
        search: '',

        // infinite scroll
        show: false, // display content after API request
        offset: 10, // items to display after scroll
        display: 10, // initial items
        trigger: 300, // how far from the bottom to trigger infinite scroll
        end: false, // no more resources

        items: 10,
        page: 1,
        loading_more: false,
        cont_activities: 0
    },
    created: function() {
        this.loadActivities();
        this.loadInfoCotiz();
    },
    methods: {
        loadActivities: function(load_more) {
            var that = this;
            this.url_activities = rmt_url + '/activities/getActivities?hb_countriesActivities=' + this.array_params.hb_countriesActivities;
            this.url_activities += '&hb_destinoActivities=' + this.array_params.hb_destinoActivities;
            this.url_activities += '&fecha_entrada=' + this.array_params.fecha_entrada;
            this.url_activities += '&fecha_salida=' + this.array_params.fecha_salida;
            this.url_activities += '&num_adultos=' + this.array_params.num_adultos;
            this.url_activities += '&num_ninios=' + this.array_params.num_ninios;
            this.url_activities += '&items=' + this.items;
            this.url_activities += '&page=' + this.page;
            if (this.array_params.num_ninios > 0) {
                for (var i = 1; i <= parseInt(this.array_params.num_ninios); i++) {
                    that.url_activities += '&num_edad[edad_' + i + ']=' + that.array_params.num_edad["edad_" + i];
                }
            }
            this.url_activities += "&view=cotizar";
            this.$http.get(encodeURI(this.url_activities)).then(function(response) {
                
                var response_activities = response.body;
                this.cont_activities = response_activities.length;
                if (this.cont_activities > 0) {
                    this.array_activities = this.array_activities.concat(response_activities);
                }
                // else {
                //     this.array_activities = response_activities;
                // }
                this.array_activities.forEach(function(element, index) {
                    if (element.activity) {
                        element.activity.modalities.sort(that.orderTarifas);
                        that.array_activities[index] = element;
                    }

                });
                if (load_more) {
                    this.display = this.display + this.offset;
                    this.loading_more = false;
                } else {
                    this.show = true;
                    this.loading = false;
                }
            }, function() {
                console.log('Error');
            });
        },
        loadDestinations: function(query) {
            if (query.length > 3) {
                this.isLoading = true;
                this.$http.get(encodeURI(rmt_url + '/busqueda/busquedaDestinosActivities?query=' + query), {
                    before(request) {
                        // abort previous request, if exists
                        if (this.previousRequest) {
                            this.previousRequest.abort();
                        }
                        // set previous request on Vue instance
                        this.previousRequest = request;
                    }
                }).then(function(response) {
                    var response_var = response.body;
                    this.options_activities = response_var;
                    this.isLoading = false;
                }, function(ex) {
                    console.log('Error');
                    console.log(ex);
                });
            }
        },
        editPax: function(pax, op) {
            if (pax == "adulto") {
                if (op == "add") {
                    this.cotiz_params.num_adultos++;
                } else {
                    this.cotiz_params.num_adultos--;
                }
            } else {
                if (op == "add") {
                    this.cotiz_params.num_ninios++;
                    this.cotiz_params.edad_menores.push({
                        no_menor: this.cotiz_params.num_ninios,
                        edad: 0,
                    });
                } else {
                    this.cotiz_params.num_ninios--;
                    this.cotiz_params.edad_menores.pop();
                }
            }
        },
        addItemCarrito: function(activity, markup, id_date, modality) {
            var date = $("#sel_" + id_date).val();
            var arreglo = {
                item: activity,
                markup: markup,
                date: date,
                modality: modality,
                tipo: "activity"
            };

            this.$http.post(this.rmt_url + "/carrito/addCarrito", { info: JSON.stringify(arreglo) }).then(function(response) {
                appCarritoHeader.array_carrito = response.body;
                const Toast = Swal.mixin({
                    toast: true,
                    position: 'bottom-end',
                    showConfirmButton: false,
                    timer: 2000
                });

                Toast.fire({
                    type: 'success',
                    title: 'Se ha agregado al carrito'
                });
            }, function() {
                console.log('Error');
            });
        },
        loadInfoCotiz: function() {
            if (typeof this.cotiz_params.num_edad != "undefined") {
                var that = this;
                var cont = 1;
                this.cotiz_params.edad_menores = [];
                Object.values(this.array_params.num_edad).forEach(function(element) {
                    that.cotiz_params.edad_menores.push({ no_menor: cont, edad: parseInt(element) });
                    cont++;
                });
            } else {
                this.cotiz_params.edad_menores = [];
            }

            this.array_estancia = {
                fecha_entrada: this.cotiz_params.fecha_entrada,
                fecha_salida: this.cotiz_params.fecha_salida,
            }

            this.model_rango_estancia = this.array_estancia.fecha_entrada + " - " + this.array_estancia.fecha_salida;

            this.options_activities = JSON.parse(localStorage.getItem("options_activities"));
            this.model_destino = JSON.parse(localStorage.getItem("selected_option_activity"));
            this.model_code = this.model_destino.code;
            this.model_destinationcode = this.model_destino.destinationcode;
        },
        setDestino: function(selectedOption, id) {
            this.model_code = selectedOption.code;
            this.model_destinationcode = selectedOption.destinationcode;

            localStorage.setItem("options_activities", JSON.stringify(this.options_activities));
            localStorage.setItem("selected_option_activity", JSON.stringify(selectedOption));
        },
        setFechaEntrada: function() {
            this.min_date = $("#bookingdate").val();
            this.selectDay = this.min_date;
        },
        printTarifa: function(total, index) {
            var rate = total; 
            
            if (this.array_activities[index].activity.currency == appCarritoHeader.currency || appCarritoHeader.currency == "OR") {
                rate = rate;
            } else if (this.array_activities[index].activity.currency == "USD" && appCarritoHeader.currency == "MXN") {
                rate = rate * appCarritoHeader.usd_venta;
            } else if (this.array_activities[index].activity.currency == "MXN" && appCarritoHeader.currency == "USD") {
                rate = rate / appCarritoHeader.usd_compra;
            } else if (this.array_activities[index].activity.currency == "MXN" && appCarritoHeader.currency == "COP") {
                rate = rate / appCarritoHeader.cop_compra;
            } else if (this.array_activities[index].activity.currency == "USD" && appCarritoHeader.currency == "COP") {
                rate = rate * appCarritoHeader.usd_venta;
                rate = rate / appCarritoHeader.cop_compra;
            }

            return this.round(rate, 2);
        },
        printMoneda: function(currency) {
            return appCarritoHeader.currency == "OR" ? currency : appCarritoHeader.currency;
        },
        orderTarifas: function(a, b) {
            if (a.rates[0].rateDetails[0].totalAmount.amount > b.rates[0].rateDetails[0].totalAmount.amount) {
                return 1;
            }

            if (a.rates[0].rateDetails[0].totalAmount.amount < b.rates[0].rateDetails[0].totalAmount.amount) {
                return -1;
            }
            return 0;
        },
        parseDate: function(date) {
            return moment(date).format('DD/MM/YYYY');
        },
        toggleInput: function() {
            
            if (this.hdp == false) {
                $("#datepicker-dp_estancia_activities_web").toggle();
                $(".datepicker__inner").toggle();
                this.hdp = true;
            }
        },
        convertToBase64Decode: function(data) {
            var result = atob(data);
            return result;
        },
        convertToBase64Encode: function(data) {
            return convertToBase64Encode(data);
        },
        convertToNumber: function(numero) {
            return convertToNumber(number);
        },
        convertToJsonApi: function(api) {
            return convertToJsonApi(api);
        },
        round: function(value, decimals) {
            return Number(Math.round(value + 'e' + decimals) + 'e-' + decimals).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
        },
        enviar: function(code) {
            $("#form_" + code).submit();
        },
        onChange: function(event) {
            this.selectDate = event.target.value;
        },
        scroll() {
            window.onscroll = ev => {
                if (window.innerHeight + window.scrollY >= ($("#activities_result")[0].offsetHeight)) {
                    if (this.loading_more == false && this.cont_activities > 0) {
                        this.page++;
                        this.loading_more = true;
                        this.loadActivities(true);
                    } else if ((this.display - 1) < this.cont_activities) {
                        this.end = true;
                    }
                }
            };
        },
    },
    mounted() {
        // track scroll event
        this.scroll();
    },
    computed: {
        filteredActivities() {
            return this.array_activities.filter(activity => {
                if (activity.activity)
                    return activity.activity.name.toLowerCase().includes(this.search.toLowerCase());
            }).slice(0, this.display);
        }
    }
});

var dp_act_web = document.getElementById('dp_estancia_activities_web');
var settings_act_dp = {
    format: 'DD/MM/YYYY',
    startOfWeek: 'sunday',
    i18n: {
        night: 'Noche',
        nights: 'Noches',
        button: 'Cerrar',
        'day-names-short': ['Dom', 'Lun', 'Mar', 'Mie', 'Jue', 'Vie', 'Sab'],
        'day-names': ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
        'month-names-short': ['Ene', 'Feb', 'Mar', 'Abr', 'Mar', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
        'month-names': ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        'info-more': 'Por favor seleccione la fecha de su estancia'
    },
    moveBothMonths: true
};
var datepicker_Act_web = new HotelDatepicker(dp_act_web, settings_act_dp);

dp_act_web.addEventListener('afterClose', function() {
    appActivities.model_rango_estancia = $("#dp_estancia_activities_web").val();
    var rango = appActivities.model_rango_estancia.split("-");
    appActivities.array_estancia = {
        fecha_entrada: rango[0].replace(/\s/g, ""),
        fecha_salida: rango[1].replace(/\s/g, ""),
    };
    $(".fecha_entrada").val(rango[0].replace(/\s/g, ""));
    $(".fecha_salida").val(rango[1].replace(/\s/g, ""));
}, false);
