	var crudServiceBaseUrl=baseUrl;


	var dataSource = new kendo.data.DataSource({
                            transport: {
                                read:  {						        
							        url: crudServiceBaseUrl + "/api/destinotourstores",
							        dataType: "json"
						    	},
							    update: {
							        url: function(options){								        	
							        	return crudServiceBaseUrl + "/api/destinotourstores/"+options.models[0].id_destino;
							        }, 
							        dataType: "json",
							        type:"PUT"								       
							    },
							    destroy: {
							        url: function(options){							        	
							        	return crudServiceBaseUrl + "/api/destinotourstores/"+options.models[0].id_destino;
							        }, 
							      	dataType: "json",
							        type:"DELETE"
							    },
							    create: {
							        url: crudServiceBaseUrl + "/api/destinotourstores",
							        dataType: "json",
							        type:"POST"
							    },
                                parameterMap: function(options, operation) {
                                    if (operation !== "read" && options.models) {
                                    	
                                    	return kendo.stringify(options.models[0]);
                                    }
                                }
                            },
                            batch: true,
                            pageSize: 10,
                         	
					schema: {
				        data: "data.destinotourstores",
				        total: "data.totalCount",				        
				        model: {
				        id: 'id_destino',
				          fields: {
				          		'id_destino':{type:'number' ,editable: false, nullable: true},
									'id_hotel':{type:'number'},
									'id_tour_store':{type:'number'},

					        }           
					      }
				   }
				});


$("#grid_destinotourstores").kendoGrid({

	dataSource: dataSource,
	toolbar: ["create", "excel"],
    columns:[
			
			{ field: 'id_destino', title: 'Id Destino', width: '200px'},
			{ field:  'id_hotel', title:  'Id Hotel', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'eq'
			                    }
			                } 
						},
			{ field:  'id_tour_store', title:  'Id Tour Store', width: '200px',
							filterable: {
			                    cell: {
			                        operator: 'eq'
			                    }
			                } 
						},
						

			
            {command: [
			"edit",

	    	"destroy"
            ],
            title: "Opciones", width: "150px"
            }
         ],
			

  	selectable: "multiple",                      
  	pageable: {
	    refresh: true,
	    pageSizes: true
	},
	editable: "popup",
	excel: {
       fileName: "destinotourstores_report.xlsx",
    },                
  	resizable: true,
  	reorderable: true,
  	//groupable: true | false,
    sortable: true,
  	filterable: {
      mode: "row"
    },
  scrollable: true
  });
