<?php
$baseUrl = "https://www2.2businesstravel.com/sur4agencias/";
// $servername = str_replace("www2.", "", $_SERVER['SERVER_NAME']);
// $baseUrl = "https://" . $_SERVER['SERVER_NAME'] . "/" . Yii::app()->baseUrl;
?>
<title>Traslados</title>
<meta http-equiv="content-type" content="text/html; charset=UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
<link rel="stylesheet" href='<?=$baseUrl?>/template/ansonika/assets/css/bootstrap.min.css'>
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css">
<link rel="stylesheet" href='<?=$baseUrl?>/template/ansonika/assets/css/vendors.css'>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/hotel-datepicker@3.6.4/dist/css/hotel-datepicker.min.css">
<link rel="stylesheet" type="text/css" href="https://unpkg.com/vue-multiselect@2.1.0/dist/vue-multiselect.min.css">
<link rel="stylesheet" href="https://pro.fontawesome.com/releases/v5.10.0/css/all.css" integrity="sha384-AYmEC3Yw5cVb3ZcuHtOA93w35dYTsvhLPVnYs9eStHfGJvOvKxVfELGroGkvsg+p" crossorigin="anonymous"/>
<link rel="stylesheet" type="text/css" href="https://rutamayatravel.com/css/traslados.css">
<script type="text/javascript">
    var rmt_url = "<?=$baseUrl?>";
    var fechaPermitido = "<?=$politicas['fecha']?>";
</script>
<main>
    
    <div class="row" id="transportacionv1" v-cloak>
        <div class="col-lg-12 mx-auto">
            <div class="box_style_1">
                <label class="label__form font-weight-bold m-0">Ciudad</label>
                <v-multiselect v-model="model_ciudad" :options="options_ciudad" group-label="tipo_destino" group-values="opciones" track-by="code" label="name" placeholder="Selecciona una Ciudad" open-direction="bottom" :searchable="true" :internal-search="false" :clear-on-select="false" :close-on-select="true" :options-limit="30" :max-height="600" @search-change="loadCiudades" :preserve-search="true" :show-labels="false" autocomplete="off" @select="setCiudad">
                    <template slot="option" slot-scope="props">
                        <span v-if="props.option.$isLabel">{{ props.option.$groupLabel }}</span>
                        <span style="font-family: Quicksand, sans-serif">
                            {{ props.option.name }}
                        </span>
                    </template>
                    <span slot="noResult">0 coincidencias. Modificar su búsqueda.</span>
                </v-multiselect>
                <label class="label__form font-weight-bold m-0">Tipo de Ruta</label>
                <div id="tipo_ruta" class="my-2 d-flex justify-content-between ">
                    <span class="text-center d-flex justify-content-center align-items-center font-weight-bold " style="font-size:var(--font_size_sur4);">{{modo.inicio}}</span>
                    <i class="fas fa-arrows-alt-h bg-info" style="font-size: 31px; cursor: pointer; margin: 0; background: #019201; border-radius: 4px; color: white; padding: 0 8px; cursor:pointer;" @click="changeModo(); validarTipoRuta();"></i>
                    <!-- <i class=" icon-resize-horizontal-2 bg-info texto-white" style="    font-size: 31px; cursor: pointer; line-height: 4px; margin: 0; background: #019201; border-radius: 4px; color: white; padding: 0 3px; cursor:pointer;" style="font-size: 20px;" @click="changeModo(); validarTipoRuta();"></i> -->
                    <span class="text-center d-flex justify-content-center align-items-center font-weight-bold " style="font-size:var(--font_size_sur4);">{{modo.fin}}</span>
                </div>
                <div class="my-2">
                    <label class="label__form font-weight-bold m-0">Destino</label>
                    <v-multiselect v-model="model_destino" :options="options" group-label="tipo_destino" group-values="opciones" track-by="Codigo" label="Nombre" placeholder="Selecciona un Hotel" open-direction="bottom" :searchable="true" :loading="isLoading" :internal-search="false" :clear-on-select="false" :close-on-select="true" :options-limit="30" :max-height="600" @search-change="loadDestinations" :preserve-search="true" :show-labels="false" autocomplete="off" @select="setDestino">
                        <template slot="option" slot-scope="props">
                            <span v-if="props.option.$isLabel">{{ props.option.$groupLabel }}</span>
                            <span style="font-family: Quicksand, sans-serif">
                                {{ props.option.Nombre }}
                            </span>
                        </template>
                        <span slot="noResult">0 coincidencias. Modificar su búsqueda.</span>
                    </v-multiselect>
                </div>
                <div class="mt-3 d-flex justify-content-between" style="background-color: white;">
                    <button id="viaje_sencillo" class="btn btn_transporte btn_right" @click="btnSencillo"> 
                        <i class="far fa-check-square text-white"></i> Viaje Sencillo</button>
                    <button id="viaje_redondo" class="btn btn_transporte selected_transporte btn_left" @click="btnRedondo"> 
                        <i class="far fa-check-square text-white"></i> Viaje Redondo</button>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="col-md-12 col-xs-12 pt-2  px-0">
                            <div class="" id="estancia_sencillo">
                                <label class="label__form font-weight-bold m-0" style="display: block;">Fecha de Servicio</label>
                                <input class="form-control has-value eventus calendar" type="hidden" data-type="date" name="fecha_salida" placeholder="Fecha Salida" id="fechaFin" data-date-format="dd/mm/yyyy" data-date-autoclose="true" autocomplete="off" required="required" readonly="">
                                <input class="form-control has-value eventus calendar" type="text" data-type="date" name="fecha_llegada" placeholder="Fecha Llegada" id="fechaIni" data-date-format="dd/mm/yyyy" data-date-autoclose="true" autocomplete="off" required="required" readonly="">
                            </div>
                        </div>
                        <div class="search-date-range main-search-date-range-js clearfix d-none" id="estancia_redondo">
                            <div class="search-date-range-arrive" style="width: 100%!important;">
                                <label class="label__form font-weight-bold m-0" style=" display: block;">Fechas de Servicios</label>
                                <input id="dp_estancia_web" v-model="model_rango_estancia" type="text" class="form-control on-focus eventus" @click="toggleInput" autocomplete="off" required="" readonly="" />
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class=" my-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="w-100 mt-3">
                                    <div class="d-flex justify-content-between">
                                        <button id="pasajeros_reducir" class="btn btn-info " @click="btnReducirPasajero();">
                                            <!-- <i class="icon-minus"></i> -->
                                            <i class="fas fa-minus"></i>
                                        </button>
                                        <div class=" w-100 d-flex align-items-center">
                                            <br>
                                            <p class="cant__pasajeros font-weight-bold">{{pasajeros.cantidad}} Pasajero(s)</p>
                                        </div>
                                        <button id="pasajeros_aumentar" class="btn btn-info " @click="btnAumentarPasajero();">
                                            <!-- <i class="icon-plus"></i> -->
                                            <i class="fas fa-plus"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="py-1 d-flex justify-content-between" style="background-color: white;    ">
                    <button id="tipo_regular" class="btn btn_transporte btn_right" @click="btnRegular(); validarTipoServicio();"><i class="far fa-check-square text-white"></i> Servicio Regular</button>
                    <button id="tipo_deluxe" class="btn btn_transporte selected_transporte btn_left" @click="btnDeluxe(); validarTipoServicio();"><i class="far fa-check-square text-white"></i> Servicio Deluxe</button>
                </div>
                <div class="mt-3">
                    <div class="text-right  mt-3">
                        <button class="btn  btn-info selected_transporte btn_reservar my-1" @click="actionAvailRequest" style="width: 100%; height:auto;"> COTIZAR</button>
                    </div>
                </div>

                <div class="banners">
                    <div class="destino mt-2">
                        <div class="contenido">
                            <h3><i class="fas fa-map-marker-alt" style="font-size: 16px;"></i> {{ (selectedDestino.Nombre) ? selectedDestino.Nombre: 'Selecciona un hotel' }} </h3>
                            <div class="tipo_ruta">
                                De {{modo.inicio}} a {{modo.fin}} - {{(tipo_servicio) ? 'Regular' : 'Deluxe'}} ({{(tipo_viaje) ? 'Viaje redondo' : 'Viaje sencillo'}})
                            </div>
                            <div class="fechas">{{(tipo_viaje) ? 'Del ' +model_rango_estancia.trim().split('-')[0]+' a '+model_rango_estancia.trim().split('-')[1] : rango_estancia.fecha_entrada}}</div>
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="pasajeros">
                                    {{pasajeros.cantidad}} Pasajero{{(pasajeros.cantidad > 1)?'s.':'.'}}
                                </div>
                            </div>
                            <div class="tarifa_neta d-flex justify-content-between align-items-center" v-if="changedInfo == false && updateInfo == false && availRequest.id_hotel != null">
                                <button class="btn btn_transporte selected_transporte btn_reservar my-1" :disabled="availRequest.id_hotel == null" id="btn_enviarForm" @click="enviarFormulario()"> RESERVAR</button>
                                <div style="font-size: 30px;">
                                    <span class="icon_cupon currency_type">$</span> {{formatPrice(availRequest.total)}} <span class=" type_money">MXN</span>
                                </div>
                            </div>
                            <div class="tarifa_neta d-flex justify-content-between align-items-center" v-else>
                                <button class="btn btn_transporte selected_transporte btn_reservar my-1" :disabled="availRequest.id_hotel == null" @click="enviarFormulario()"> RESERVAR</button>
                                <div style="font-size: 30px;">
                                    <span class="icon_cupon currency_type">$</span> ----<span class=" type_money"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- <div class="col-lg-6"> -->
            <!-- <ul class="nav nav-tabs" id="myTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Traslados</a>
                </li>
                <li class="nav-item" role="presentation">
                    <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Términos y Condiciones</a>
                </li>
            </ul> -->
            <!-- <div class="tab-content" id="myTabContent">
                <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                    <div style="height: 200px; background:url(https://tourstores.com/transfers/images/transfer1.jpg); background-position: center center; background-size: cover; background-repeat: no-repeat;">
                    </div>
                </div>
                <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                    <div class="pt-3 overflow-hidden" style="height: 200px; overflow-x:hidden;">
                        <h4>Transportación desde Aeropuerto de Cancun</h4>
                        <p>Las tarifas son por vehículo hasta 14 pasajeros.</p>
                        <h6>Servico Regular</h6>
                        <ul class="">
                            <li>
                                Transporte privado en camionetas de modelo reciente
                            </li>
                            <li>
                                Salida inmediata
                            </li>
                            <li>
                                Firma con tu nombre a tu llegada
                            </li>
                            <li>
                                Asiento de bebe disponible
                            </li>
                        </ul>
                        <h6>Servico Deluxe</h6>
                        <ul>
                            <li>
                                Transporte privado de lujo en vehículos GM Suburban o Mercedes Benz Viano de hasta 5 pasajeros</a>
                            <li>
                                Asientos de piel</a>
                            </li>
                            <li>
                                Wifi</a>
                            </li>
                            <li>
                                Agua embotellada y refrescos</a>
                            </li>
                            <li>
                                Salida inmediata</a>
                            </li>
                            <li>
                                Firma con tu nombre a tu llegada</a>
                            </li>
                            <li>
                                Asiento para bebe disponibles</a>
                            </li>
                        </ul>
                        <h6>TERMINOS Y CONDICIONES:</h6>
                        <ul>
                            <li>
                                El cupón de servicio te será solicitado al momento de registrarte en la taquilla o por el guía al momento de abordar
                            </li>
                        </ul>
                        <h6>POLÍTICAS DE CANCELACIÓN</h6>
                        <ul>
                            <li>
                                Unicamente cancelando el servicio 48 horas antes de la salida, se reembolsará el 100% de la tarifa.
                            </li>
                            <li>
                                Si se cancela el servicio faltando menos de 48 horas para la salida, no procede reembolso.
                            </li>
                        </ul>
                    </div>
                </div>
            </div> -->
        <!-- </div> -->
        <form action="<?= Yii::app()->createUrl('transportacion/create') ?>" method="post" id="form-transportacion">
            <input type="hidden" name="idtour" class="eventus" value="0">
            <input type="hidden" name="direccion" id="direccion" v-model="availRequest.direccion">
            <input type="hidden" name="id_hotel" v-model="availRequest.id_hotel" class="eventus" id="hotel">
            <input type="hidden" name="nombre_hotel" v-model="availRequest.nombre_hotel" class="eventus" id="nombre_hotel">
            <input type="hidden" name="code" v-model="availRequest.code" class="eventus" id="code">
            <input type="hidden" name="zona" v-model="availRequest.zona" class="eventus" id="zona">
            <input type="hidden" name="city" v-model="availRequest.city" class="eventus" id="city">
            <input type="hidden" name="servicio" v-model="availRequest.tipo_servicio">
            <input type="hidden" name="tipo_servicio" id="servicio" v-model="availRequest.tipo_servicio">
            <input type="hidden" name="adultos" id="adultos" v-model="availRequest.adultos">
            <input type="hidden" name="fecha_salida" v-model="availRequest.fecha_salida">
            <input type="hidden" name="fecha_llegada" v-model="availRequest.fecha_llegada">
            <input type="hidden" name="deluxe" id="deluxe" v-model="availRequest.deluxe">
            <input type="hidden" name="tarifa_neta" id="tarifa_neta" v-model="availRequest.tarifa_neta">
            <input type="hidden" name="total" id="total" v-model="availRequest.total">
            <input type="hidden" name="moneda" id="moneda" v-model="availRequest.moneda">
            <input type="hidden" name="okpass" v-model="availRequest.okpass" id="okpass">
        </form>
    </div>
        
</main>

<script type="text/javascript" src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script type="text/javascript">

    $.getScript('https://rutamayatravel.com/js/vue@2.js?v=1', function() {
        $.getScript('https://rutamayatravel.com/js/vue-multiselect.min.js');

        $.getScript('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js', function() {
            $.getScript('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/locale/es-do.min.js');
        });
        
        $.getScript('https://cdn.jsdelivr.net/npm/fecha@3.0.2/lib/fecha.umd.min.js');
        $.getScript('https://cdn.jsdelivr.net/npm/hotel-datepicker@3.6.4/dist/js/hotel-datepicker.min.js');

        $.getScript('https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js', function() {
            $.getScript('https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.3.0/js/bootstrap-datepicker.js', function() { 
                $.getScript('https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/locales/bootstrap-datepicker.es.min.js');
                $.getScript('https://rutamayatravel.com/js/vue-resource.min.js?v=1.1', function() {
                    $.getScript('<?=$baseUrl?>/vue/transportacion_vue.js?v=<?=time()?>', function() {
                        console.log("sel_destinos");
                    });
                });
            });
        });


    });
</script>
<!-- <script type="text/javascript" src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js"></script> -->
<!-- <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js"></script> -->
<!-- <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/locales/bootstrap-datepicker.es.min.js"></script> -->

<!-- <script type="text/javascript" src="<?=$baseUrl?>/vue/fecha.min.js?v=27"></script> -->

<!-- <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/fecha@3.0.2/lib/fecha.umd.min.js"></script> -->
<!-- <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/hotel-datepicker@3.6.4/dist/js/hotel-datepicker.min.js"></script> -->

<!-- <script type="text/javascript" src="https://rutamayatravel.com/js/vue@2.js"></script>
<script type="text/javascript" src="https://rutamayatravel.com/js/vue-multiselect.min.js"></script>
<script type="text/javascript" src="https://rutamayatravel.com/js/vue-resource.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/locale/es-do.min.js"></script>
<script type="text/javascript" src="<?=$baseUrl?>/vue/transportacion_vue.js?v=<?=time()?>"></script> -->


