<?php
$model_agencia = Agencias::model()->findByPk($reservacion->id_agencia);
?>
<!doctype html>
<html>
<?php session_start() ?>

<head>
    <meta charset="UTF-8">
    <title>Reserbus</title>
    <?php Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl . "/css/pago.css?v=" . time());  ?>

</head>

<body>
    <div class="whitepaper mx-auto row">
        <div class="Header">
            <!--             <div class="Logo_empresa">
                [img]
            </div> -->
            <div class="Logo_paynet">
                <div>Servicio a pagar</div>
                <img src="<?= Yii::app()->baseUrl ?>/images/paynet_logo.png" style="width: 50%;" alt="Logo Paynet">
            </div>
        </div>
        <div class="Data row justify-content-center align-items-center m-0">
            <div class="col-md-6 p-0">
                <div class="Big_Bullet p-0">
                    <span></span>
                </div>
                <div class="col1 justify-content-center col-md-10">
                    <h3>Fecha límite de pago</h3>
                    <h6 class="text-center"><?php
                                            setlocale(LC_ALL, "es_ES");
                                            $fecha = $charge->due_date;
                                            $hora = date('H:i:s', strtotime($charge->due_date));
                                            $fecha = strftime('%d de %B %Y, a las');
                                            echo $fecha . ' ' . $hora
                                            ?>
                    </h6>
                    <div class="text-center">
                        <img src="<?= $charge->payment_method->barcode_url ?>" style="width: 70%;" alt="Código de Barras">
                    </div>
                    <div class="text-center fw-bold"><span><?= $charge->payment_method->reference ?></span></div>
                    <div>
                        <p>En caso de que el escáner no sea capaz de leer el código de barras, escribir la referencia tal como se muestra.</p>
                    </div>

                </div>
            </div>
            <div class="col2 col-md-4">
                <h2 class="text-white fw-bold">Total a pagar</h2>
                <h1 class="text-white">
                    <?= number_format($charge->amount, 2, ".", ",") ?>
                    <span></span><small> MXN</small></h1>
                <span class="note fw-bold">La comisión por recepción del pago varía de acuerdo a los términos y condiciones que cada cadena comercial establece.</span>
            </div>
        </div>
        <div class="DT-margin"></div>
        <div class="Data mx-auto col-md-10 p-0">
            <div>
                <div class="Big_Bullet">
                    <span></span>
                </div>
                <div class="col1">
                    <h3>Detalles de la compra</h3>
                </div>
            </div>
        </div>
        <div class="Table-Data row justify-content-center m-0">
            <div class="table-row row d-flex ustify-content-center color1">
                <div class="row col-md-4 justify-content-center align-items-center ">Descripción</div>
                <div class="col-md-8">
                    <span><?= $charge->description ?></span>
                </div>
            </div>
            <div class="table-row row d-flex ustify-content-center color2">
                <div class="row col-md-4 justify-content-center align-items-center">Fecha y hora</div>
                <div class="col-md-8">
                    <span><?php
                            echo date('d/m/Y', strtotime($charge->customer->creation_date));
                            ?>
                </div>
            </div>
            <div class="table-row row d-flex ustify-content-center color1">
                <div class="row col-md-4 justify-content-center align-items-center"> Correo del cliente</div>
                <div class="col-md-8">
                    <span><?= $charge->customer->email ?></span>
                </div>
            </div>
        </div>
        <div class="DT-margin"></div>
        <div class="row mx-auto col-md-10 justify-content-between m-0 p-0">

            <div class="Big_Bullet">
                <span></span>
            </div>
            <div class="col1 col-md-5 ">
                <h3>Como realizar el pago</h3>
                <ol>
                    <li>Acude a cualquier tienda Seven Eleven</li>
                    <li>Entrega al cajero el código de barras y menciona que realizarás un pago de servicio Paynet</li>
                    <li>Realizar el pago en efectivo por $<?= $charge->amount ?> MXN </li>
                    <li>Conserva el ticket para cualquier aclaración</li>
                </ol>
                <p>Si tienes dudas comunícate a <?= $model_agencia->nombre_agencia ?> al teléfono <?= $model_agencia->celular ?> o al correo <?= $model_agencia->email_agencia ?>.</p>
            </div>
            <div class="col1  col-md-5">
                <h3>Instrucciones para el cajero</h3>
                <ol>
                    <li>Ingresar al menú de Pago de Servicios</li>
                    <li>Seleccionar Paynet</li>
                    <li>Escanear el código de barras o ingresar el núm. de referencia</li>
                    <li>Ingresa la cantidad total a pagar</li>
                    <li>Cobrar al cliente el monto total más la comisión</li>
                    <li>Confirmar la transacción y entregar el ticket al cliente</li>
                </ol>
                <p>Para cualquier duda sobre como cobrar, por favor llamar al teléfono +52 (55) 5351 7371 en un horario de 8am a 9pm de lunes a domingo</p>
            </div>

        </div>

        <div class="logos-tiendas row mx-auto col-md-10 justify-content-center m-0 p-0">

            <div>
                <ul>
                    <li>
                        <img src="<?= Yii::app()->baseUrl ?>/images/01.png" width="100%" height="100%">
                    </li>
                </ul>
            </div>
            <div class="mx-auto text-center d-flex align-items-center">
                <p>¿Quieres pagar en otras tiendas? visítanos en: www.openpay.mx/tiendas</p>
            </div>

        </div>
        <div class="Powered row justify-content-center p-3">

            <img src="<?= Yii::app()->baseUrl ?>/images/powered_openpay.png" alt="Powered by Openpay" width="150">

            <!--   <a href="#">Imprimir</a>
            <a href="#">Regresar</a> -->
        </div>
    </div>
    <div style="height: 40px; width: 100%; float left;">

    </div>

</body>

</html>