<h1 id="tarifas">Más tarifas</h1>
<table class="table table-striped cart-list add_bottom_30">
    <thead>
        <tr>
            <th>
                Modalidad
            </th>
            <th>
                Precio / persona
            </th>
            <th>
                Importante
            </th>
            <th>
                Total
            </th>
            <th>
                Acciones
            </th>
        </tr>
    </thead>
    <tbody>
        <tr v-for="(item_tarifa, index_tarifa) in tour.tarifas">
            <td class="d-flex align-items-center">
                <div class="thumb_cart">
                    <img v-if="array_params.destino == 'c_8'" :src="'https://2businesstravel.com/rentas/images/multimedia/' + tour.imagen" alt="Image">
                    <img v-else :src="'https://www.rutamayatravel.com/imagenes/tours/' + tour.imagen" alt="Image">
                </div>
                <span v-text="item_tarifa.alias" class="item_cart mt-0"></span>
            </td>
            <td>
                <table class="table table-sm table-borderless table-striped tabla-precio-persona mb-0" style="background: none;">
                    <tr v-for="(pax_cost, index_tour) in item_tarifa.desglose" style="background: none;">
                        <td v-if="pax_cost.tipo == 'Adulto' || array_params.num_ninios > 0">
                            <div v-if="es_descuento == true" v-text="'$ ' + printTotalPasajero(item_tarifa, index_tour, true) + ' ' + printMonedaMenorTarifa(item_tarifa)"></div>
                            <div v-else><span style="font-weight: bold;" v-text="'$ ' + printTotalPasajero(item_tarifa, index_tour) + ' '"></span> <span v-text="printMonedaMenorTarifa(item_tarifa)"></span></div>
                        </td>
                        <td v-if="pax_cost.tipo == 'Adulto'" v-text="'Adulto (Mayor a ' + pax_cost.edad_min + ' años)'"></td>
                        <td v-else-if="array_params.num_ninios > 0" v-text="'Menor (De ' + pax_cost.edad_min + ' a ' + pax_cost.edad_max  + ' años)'"></td>
                    </tr>
                </table>
            </td>
            <td class="cont-iconos-descripcion">
                <!--End strip -->

                <a v-if="item_tarifa.descripcion" href="#" class="btn btn-sm btn-info tooltip-1" data-placement="top" title="Descripción" data-toggle="modal" :data-target="'#descripcionTour'+index_tarifa"><i class="icon-info"></i></a>

                <a v-if="item_tarifa.restricciones" href="#" class="btn btn-sm btn-warning" data-toggle="modal" :data-target="'#restriccionTour'+index_tarifa"><i class="icon-attention"></i></a>

                <a class="btn btn-sm btn-danger" v-tooltip="'Fecha limite de pago: '+(item_tarifa.pago_inmediato=='1'? moment().format('DD-MM-YYYY'):moment(item_tarifa.fecha_limite).format('DD-MM-YYYY')) " data-html="true" data-toggle="tooltip" data-placement="top">
                    <span class="tooltip-item"><i class="fas fa-ban"></i></span>
                    <div class="tooltip-content"></div>
                </a>


                <!-- Modal descripcion -->
                <div class="modal fade" :id="'descripcionTour'+index_tarifa" tabindex="-1" role="dialog" aria-labelledby="myReviewLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title" id="myReviewLabel">Información</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <div id="message-review">
                                    {{item_tarifa.descripcion}}
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <!-- End modal descripcion -->
                <!-- Modal restricciones -->
                <div class="modal fade" :id="'restriccionTour'+index_tarifa" tabindex="-1" role="dialog" aria-labelledby="myReviewLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title" id="myReviewLabel">Restricciones</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <div id="message-review">
                                    {{item_tarifa.restricciones}}
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <!-- End modal restricciones -->
            </td>
            <td>
                <strong v-text="'$ ' + printTotalReserva(item_tarifa, false, true) + ' '  "></strong><span v-text="printMonedaMenorTarifa(item_tarifa)"></span>
            </td>
            <td class="options d-flex">
                <form action="<?= Yii::app()->createUrl("tourReservacion/create") ?>" method="POST">
                    <input type="hidden" value="<?= $_GET['us-A'] ?>" name="us-A">
                    <input type="hidden" name="rooming" :value="JSON.stringify(array_params)">
                    <input type="hidden" name="tour" :value="JSON.stringify(tour)">
                    <input type="hidden" name="rate_code" :value="index_tarifa">
                    <input type="hidden" name="importe" :value="printTotalReserva(item_tarifa, true)">
                    <input type="hidden" name="id_tarifa" :value="item_tarifa.id_tarifa">
                    <input type="hidden" name="es_descuento" v-model="es_descuento">
                    <input type="hidden" name="url_cotizacion" v-model="url_cotizacion">
                    <!-- <button class="tooltip_flip tooltip-effect-1 tooltip-reservar boton-reservar" type="submit"><i class="icon-ok"></i><span class="tooltip-content-flip"><span class="tooltip-back">Reservar</span></span></button> -->
                    <div v-if="valida_disponibilidad">
                        <button class="btn_1 green" type="submit">Reservar</button>
                    </div>
                    <div v-else>
                        <button class="btn_1 red" type="button">Consulte otra fecha</button>
                    </div>
                </form>
                <!-- <a class="tooltip_flip tooltip-effect-1" style="cursor: pointer; color: #e14d67; align-self: center;" type="button" @click="addItemCarrito(tour, index_tarifa)"><i class="icon-cart"></i><span class="tooltip-content-flip"><span class="tooltip-back">Agregar al carrito</span></span></a> -->
            </td>
        </tr>
    </tbody>
</table>