﻿<?php $assets= Yii::app()->baseUrl."/template/ansonika/assets"; ?>
<link rel="stylesheet" href="<?=$assets.'/css/admin.css';?>">

<style>
    .strip_booking h3.activity_booking:before {
        content: "\21"!important;
    }
    @media (max-width: 767px) {
        .margin_60 {
            padding-top: 70px;
        }
    }

    @media (min-width: 768px) {
        .margin_60 {
            padding-top: 120px;
            padding-bottom: 60px;
        }
    }
</style>


<main>
    <div class="margin_60 container" id="booking_list">
        <span v-show="loading_reservas">Cargando Datos...</span>
        <div id="tabs" class="tabs" v-show="show_content">
            <nav>
                <ul>
                    <li data-div="prox_pagos" @click="changeDiv"><a href="#section-1" class="icon-warning-empty"><span>Próximos pagos</span></a></li>
                    <li data-div="reservas" @click="changeDiv"><a href="#section-2" class="icon-booking"><span>Reservas</span></a></li>
                    <li data-div="activities" @click="changeDiv"><a href="#section-3" class="icon-direction-1"><span>Activities</span></a></li>
                    <li data-div="tours" @click="changeDiv"><a href="#section-4" class="icon-map-1"><span>Tours</span></a></li>
                    <li data-div="historial-facturacion" @click="changeDiv"><a href="#section-5" class="icon-money-2"><span>Pagos y Facturación</span></a></li>
                </ul>
            </nav>
            <div class="content">
                <section id="section-1">
                    <div v-if="array_prox_pagos_bookings.length == 0 && array_prox_pagos_activities.length == 0 && array_prox_pagos_tours.length == 0">
                        <h3>No hay reservaciones próximas a vencer en los siguientes {{ days_prox_pagos }} días.</h3>
                    </div>
                    <div v-else>
                        <div class="strip_booking" v-for="booking in array_prox_pagos_bookings">
                            <div class="row">
                                <div class="col-lg-2 col-md-2">
                                    <div class="date">
                                        <span class="month" v-if="booking.estatus == 'C'" v-text="parseDate(booking.fecha_limite, 'MMM')"></span>
                                        <span class="month" v-else style="background-color: #33ad85;" v-text="parseDate(booking.fecha_limite, 'MMM')"></span>
                                        <span class="day">
                                            <strong v-if="booking.estatus == 'C'">{{ parseDate(booking.fecha_limite, "DD") }}</strong>
                                            <strong v-else style="color: #33ad85;">{{ parseDate(booking.fecha_limite, "DD") }}</strong>
                                            {{ parseDate(booking.fecha_limite, "YYYY") }}
                                        </span>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-5">
                                    <h3 class="hotel_booking">
                                        {{ booking.idHotel.nombre_hotel }}
                                        <span v-for="desglose in booking.reservacionDesgloses">
                                            {{ desglose.num_adultos }} Adulto(s) - {{ desglose.num_ninios }} Menor(es) / {{ numberNigths(booking.fecha_inicial, booking.fecha_final) }} Noches
                                        </span>
                                        <br>
                                        <span><strong>Cliente:</strong> {{ booking.nombre_cliente + ' ' + booking.apellido_cliente }}</span>
                                        <span><strong>Saldo:</strong> $ {{ round(booking.saldo,2) }}</span>
                                        <span><strong>Fecha entrada:</strong> {{ parseDate(booking.fecha_inicial,'DD/MM/YYYY') }}</span>
                                    </h3>
                                </div>
                                <div class="col-lg-2 col-md-3">
                                    <ul class="info_booking">
                                        <li><strong>Cupón</strong> {{ booking.id_reservacion }}</li>
                                        <li><strong>Reservó</strong> {{ parseDate(booking.log,"DD/MM/YYYY") }}</li>
                                    </ul>
                                </div>
                                <div class="col-lg-2 col-md-2">
                                    <div class="booking_buttons">
                                        <a :href="'<?= Yii::app()->baseUrl; ?>/reservacion/view/' + booking.id_reservacion" class="btn_2" target="_blank">Ver detalle</a>
                                        <a href="#0" class="btn_3">Solicitar cancelación</a>
                                    </div>
                                </div>
                            </div>
                            <!-- End row -->
                        </div>
                        <!-- End strip booking -->
                        <div class="strip_booking" v-for="activity in array_prox_pagos_activities">
                            <div class="row">
                                <div class="col-lg-2 col-md-2">
                                    <div class="date">
                                        <span class="month" v-if="activity.estatus == 'C'" v-text="parseDate(activity.fecha_limite, 'MMM')"></span>
                                        <span class="month" v-else style="background-color: #33ad85;" v-text="parseDate(activity.fecha_limite, 'MMM')"></span>
                                        <span class="day">
                                            <strong v-if="activity.estatus == 'C'">{{ parseDate(activity.fecha_limite, "DD") }}</strong>
                                            <strong v-else style="color: #33ad85;">{{ parseDate(activity.fecha_limite, "DD") }}</strong>
                                            {{ parseDate(activity.fecha_limite, "YYYY") }}
                                        </span>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-5">
                                    <h3 class="hotel_booking activity_booking">{{ activity.actividad }}
                                        <span v-for="desglose in activity.activityReservacionDesgloses">
                                            {{ desglose.num_adultos }} Adulto(s) - {{ desglose.num_ninios }} Menor(es)
                                        </span>
                                        <br>
                                        <span><strong>Cliente:</strong> {{ activity.nombre_cliente + ' ' + activity.apellido_cliente }}</span>
                                        <span><strong>Saldo:</strong> {{ round(activity.saldo,2) + " " + JSON.parse(activity.Booking).currency }}</span>
                                        <span><strong>Fecha entrada:</strong> {{ parseDate(activity.fecha_inicial,'DD/MM/YYYY') }}</span>
                                    </h3>
                                </div>
                                <div class="col-lg-2 col-md-3">
                                    <ul class="info_booking">
                                        <li><strong>Cupón</strong> A{{ activity.id_reservacion }}</li>
                                        <li><strong>Reservó</strong> {{ parseDate(activity.log,"DD/MM/YYYY") }}</li>
                                    </ul>
                                </div>
                                <div class="col-lg-2 col-md-2">
                                    <div class="booking_buttons">
                                        <a :href="'<?= Yii::app()->baseUrl; ?>/activities/view/' + activity.id_reservacion" class="btn_2" target="_blank">Ver detalle</a>
                                        <a href="#0" class="btn_3">Solicitar cancelación</a>
                                    </div>
                                </div>
                            </div>
                            <!-- End row -->
                        </div>
                        <div class="strip_booking" v-for="tour in array_prox_pagos_tours">
                            <div class="row">
                                <div class="col-lg-2 col-md-2">
                                    <div class="date">
                                        <span class="month" v-if="tour.estatus == 'C'" v-text="parseDate(tour.fecha_limite, 'MMM')"></span>
                                        <span class="month" v-else style="background-color: #33ad85;" v-text="parseDate(tour.fecha_limite, 'MMM')"></span>
                                        <span class="day">
                                            <strong v-if="tour.estatus == 'C'">{{ parseDate(tour.fecha_limite, "DD") }}</strong>
                                            <strong v-else style="color: #33ad85;">{{ parseDate(tour.fecha_limite, "DD") }}</strong>
                                            {{ parseDate(tour.fecha_limite, "YYYY") }}
                                        </span>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-5">
                                    <h3 class="tours_booking">{{ tour.idTour.nombre }}
                                        <span>{{ tour.adultos }} Adulto(s) - {{ tour.menores }} Menor(es)</span>
                                        <br>
                                        <span><strong>Cliente:</strong> {{ tour.cliente_nombre + ' ' + tour.cliente_apellido }}</span>
                                        <span><strong>Saldo:</strong> $ {{ round(tour.saldo,2) + " " + tour.idTarifa.moneda }}</span>
                                        <span><strong>Fecha entrada:</strong> {{ parseDate(tour.fecha_inicio,'DD/MM/YYYY') }}</span>
                                    </h3>
                                </div>
                                <div class="col-lg-2 col-md-3">
                                    <ul class="info_booking">
                                        <li><strong>Cupón</strong> T{{ tour.id_tourReservacion }}</li>
                                        <li><strong>Reservó</strong> {{ parseDate(tour.log,"DD/MM/YYYY") }}</li>
                                    </ul>
                                </div>
                                <div class="col-lg-2 col-md-2">
                                    <div class="booking_buttons">
                                        <a :href="'<?= Yii::app()->baseUrl; ?>/tourReservacion/view/' + tour.id_tourReservacion" class="btn_2" target="_blank">Ver detalle</a>
                                        <a href="#0" class="btn_3">Solicitar cancelación</a>
                                    </div>
                                </div>
                            </div>
                            <!-- End row -->
                        </div>
                    </div>
                </section>

                <section id="section-2">
                    <div id="tools">
                        <div class="form-row align-items-center">
                            <div class="col-sm-4">
                                <input type="text" class="form-control" placeholder="Nombre hotel" autocomplete="off" v-model="search_reserva">
                            </div>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" placeholder="Cliente" autocomplete="off" v-model="search_customer_reserva">
                            </div>
                            <div class="col-sm-3">
                                <input type="text" class="form-control" placeholder="Pasajeros" autocomplete="off" v-model="search_pax_reserva" value="juan">
                            </div>
                            <div class="col-sm-2">
                                <select v-model="order_fecha_reserva" class="form-control">
                                    <option value="" selected>Ordenar por fecha</option>
                                    <option value="oldest">Más viejo</option>
                                    <option value="newest">Más reciente</option>
                                </select>
                            </div>
                        </div>
                        <!-- <div class="row">
                            <div class="col-lg-2 col-md-3 col-6">
                                <div class="styled-select-filters">
                                    <select name="sort_date" id="sort_date">
                                        <option value="" selected>Ordenar por fecha</option>
                                        <option value="oldest">Más viejo</option>
                                        <option value="recent">Más reciente</option>
                                    </select>
                                </div>
                            </div>
                        </div> -->
                    </div>
                    <!--/tools -->

                    <div class="strip_booking" v-for="booking in filteredBookings">
                        <div class="row">
                            <div class="col-lg-2 col-md-2">
                                <div class="date">
                                    <span class="month" v-if="booking.estatus == 'C'" v-text="parseDate(booking.fecha_inicial, 'MMM')"></span>
                                    <span class="month" v-else style="background-color: #33ad85;" v-text="parseDate(booking.fecha_inicial, 'MMM')"></span>
                                    <span class="day">
                                        <strong v-if="booking.estatus == 'C'">{{ parseDate(booking.fecha_inicial, "DD") }}</strong>
                                        <strong v-else style="color: #33ad85;">{{ parseDate(booking.fecha_inicial, "DD") }}</strong>
                                        {{ parseDate(booking.fecha_inicial, "YYYY") }}
                                    </span>
                                </div>
                                <div class="text-center" v-if="tipo_usuario == 'Agencia'">
                                    <span v-if="booking.estatus == 'C'" class="badge badge-danger">Cancelado</span>
                                    <span v-else="booking.estatus == 'R'" class="badge badge-success">Liberado</span>
                                </div>
                                <div class="text-center" v-else>
                                    <span v-if="booking.estatus == 'R'" class="badge badge-success">Liberado</span>
                                    <span v-else-if="booking.estatus == 'PH'" class="badge badge-success">Pagado Hotel</span>
                                    <span v-else-if="booking.estatus == 'RE'" class="badge badge-info">Reinstalado</span>
                                    <span v-else-if="booking.estatus == 'PC'" class="badge badge-warning">Pendiente cancelación</span>
                                    <span v-else-if="booking.estatus == 'C'" class="badge badge-danger">Cancelado</span>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-5">
                                <h3 class="hotel_booking">
                                    {{ booking.idHotel.nombre_hotel }}
                                    <span v-for="desglose in booking.reservacionDesgloses">
                                        {{ desglose.num_adultos }} Adulto(s) - {{ desglose.num_ninios }} Menor(es) / {{ numberNigths(booking.fecha_inicial, booking.fecha_final) }} Noches
                                    </span>
                                    <br>
                                    <span><strong>Cliente:</strong> {{ booking.nombre_cliente + ' ' + booking.apellido_cliente }}</span>
                                    <span><strong>Saldo:</strong> $ {{ round(booking.saldo,2) }}</span>
                                    <span><strong>Fecha límite pago:</strong> {{ parseDate(booking.fecha_limite,'DD/MM/YYYY') }}</span>
                                </h3>
                            </div>
                            <div class="col-lg-2 col-md-3">
                                <ul class="info_booking">
                                    <li><strong>Cupón</strong> {{ booking.id_reservacion }}</li>
                                    <li><strong>Reservó</strong> {{ parseDate(booking.log,"DD/MM/YYYY") }}</li>
                                </ul>
                            </div>
                            <div class="col-lg-2 col-md-2">
                                <div class="booking_buttons">
                                    <a :href="'<?= Yii::app()->baseUrl; ?>/reservacion/view/' + booking.id_reservacion" class="btn_2" target="_blank">Ver detalle</a>
                                    <a href="#0" class="btn_3">Solicitar cancelación</a>
                                </div>
                            </div>
                        </div>
                        <!-- End row -->
                    </div>
                    <!-- End strip booking -->
                </section>
                <!-- End section 1 -->

                <section id="section-3">
                    <div style="background: #eee; padding: 5px; margin-bottom: 15px;">
                        <div class="form-row align-items-center">
                            <label class="col-sm-1 col-form-label col-form-label-sm">Activity</label>
                            <div class="col-sm-4">
                                <input type="text" class="form-control" placeholder="Filtrar por nombre de activity" autocomplete="off" v-model="search_activity">
                            </div>
                            <label class="col-sm-1 col-form-label col-form-label-sm">Cliente</label>
                            <div class="col-sm-4">
                                <input type="text" class="form-control" placeholder="Filtrar por nombre de cliente" autocomplete="off" v-model="search_pax_activity">
                            </div>
                            <div class="col-sm-2">
                                <select v-model="order_fecha_activity" class="form-control">
                                    <option value="" selected>Ordenar por fecha</option>
                                    <option value="oldest">Más viejo</option>
                                    <option value="newest">Más reciente</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="strip_booking" v-for="activity in filteredActivities">
                        <div class="row">
                            <div class="col-lg-2 col-md-2">
                                <div class="date">
                                    <span class="month" v-if="activity.estatus == 'C'" v-text="parseDate(activity.fecha_inicial, 'MMM')"></span>
                                    <span class="month" v-else style="background-color: #33ad85;" v-text="parseDate(activity.fecha_inicial, 'MMM')"></span>
                                    <span class="day">
                                        <strong v-if="activity.estatus == 'C'">{{ parseDate(activity.fecha_inicial, "DD") }}</strong>
                                        <strong v-else style="color: #33ad85;">{{ parseDate(activity.fecha_inicial, "DD") }}</strong>
                                        {{ parseDate(activity.fecha_inicial, "YYYY") }}
                                    </span>
                                </div>
                                <div class="text-center">
                                    <span v-if="activity.estatus == 'R'" class="badge badge-success">Liberado</span>
                                    <span v-else-if="activity.estatus == 'C'" class="badge badge-danger">Cancelado</span>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-5">
                                <h3 class="hotel_booking activity_booking">{{ activity.actividad }}
                                    <span v-for="desglose in activity.activityReservacionDesgloses">
                                        {{ desglose.num_adultos }} Adulto(s) - {{ desglose.num_ninios }} Menor(es)
                                    </span>
                                    <br>
                                    <span><strong>Cliente:</strong> {{ activity.nombre_cliente + ' ' + activity.apellido_cliente }}</span>
                                    <span><strong>Saldo:</strong> {{ round(activity.saldo,2) + " " + JSON.parse(activity.Booking).currency }}</span>
                                    <span><strong>Fecha límite pago:</strong> {{ parseDate(activity.fecha_limite,'DD/MM/YYYY') }}</span>
                                </h3>
                            </div>
                            <div class="col-lg-2 col-md-3">
                                <ul class="info_booking">
                                    <li><strong>Cupón</strong> A{{ activity.id_reservacion }}</li>
                                    <li><strong>Reservó</strong> {{ parseDate(activity.log,"DD/MM/YYYY") }}</li>
                                </ul>
                            </div>
                            <div class="col-lg-2 col-md-2">
                                <div class="booking_buttons">
                                    <a :href="'<?= Yii::app()->baseUrl; ?>/activities/view/' + activity.id_reservacion" class="btn_2" target="_blank">Ver detalle</a>
                                    <a href="#0" class="btn_3">Solicitar cancelación</a>
                                </div>
                            </div>
                        </div>
                        <!-- End row -->
                    </div>
                </section>
                <!-- End section 2 -->

                <section id="section-4">
                    <div style="background: #eee; padding: 5px; margin-bottom: 15px;">
                        <div class="form-row align-items-center">
                            <label class="col-sm-1 col-form-label col-form-label-sm">Tour</label>
                            <div class="col-sm-4">
                                <input type="text" class="form-control" placeholder="Filtrar por nombre de tour" autocomplete="off" v-model="search_tour">
                            </div>
                            <label class="col-sm-1 col-form-label col-form-label-sm">Cliente</label>
                            <div class="col-sm-4">
                                <input type="text" class="form-control" placeholder="Filtrar por nombre de cliente" autocomplete="off" v-model="search_pax_tour">
                            </div>
                            <div class="col-sm-2">
                                <select v-model="order_fecha_tour" class="form-control">
                                    <option value="" selected>Ordenar por fecha</option>
                                    <option value="oldest">Más viejo</option>
                                    <option value="newest">Más reciente</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="strip_booking" v-for="tour in filteredTours">
                        <div class="row">
                            <div class="col-lg-2 col-md-2">
                                <div class="date">
                                    <span class="month" v-if="tour.estatus == 'C'" v-text="parseDate(tour.fecha_inicio, 'MMM')"></span>
                                    <span class="month" v-else style="background-color: #33ad85;" v-text="parseDate(tour.fecha_inicio, 'MMM')"></span>
                                    <span class="day">
                                        <strong v-if="tour.estatus == 'C'">{{ parseDate(tour.fecha_inicio, "DD") }}</strong>
                                        <strong v-else style="color: #33ad85;">{{ parseDate(tour.fecha_inicio, "DD") }}</strong>
                                        {{ parseDate(tour.fecha_inicio, "YYYY") }}
                                    </span>
                                </div>
                                <div class="text-center" v-if="tipo_usuario == 'Agencia'">
                                    <span v-if="tour.estatus == '1'" class="badge badge-success">Liberado</span>
                                    <span v-else-if="tour.estatus == 'R'" class="badge badge-primary">Reservado</span>
                                    <span v-else-if="tour.estatus == 'P'" class="badge badge-info">Pagado</span>
                                    <span v-else class="badge badge-danger">Cancelado</span>
                                </div>
                                <div class="text-center" v-else>
                                    <span v-if="tour.estatus == 'C'" class="badge badge-danger">Cancelado</span>
                                    <span v-else class="badge badge-success">Reservado</span>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-5">
                                <h3 class="tours_booking">{{ tour.idTour.nombre }}
                                    <span>{{ tour.adultos }} Adulto(s) - {{ tour.menores }} Menor(es)</span>
                                    <br>
                                    <span><strong>Cliente:</strong> {{ tour.cliente_nombre + ' ' + tour.cliente_apellido }}</span>
                                    <span><strong>Saldo:</strong> $ {{ round(tour.saldo,2) + " " + tour.idTarifa.moneda }}</span>
                                    <span><strong>Fecha límite pago:</strong> {{ parseDate(tour.fecha_limite,'DD/MM/YYYY') }}</span>
                                </h3>
                            </div>
                            <div class="col-lg-2 col-md-3">
                                <ul class="info_booking">
                                    <li><strong>Cupón</strong> T{{ tour.id_tourReservacion }}</li>
                                    <li><strong>Reservó</strong> {{ parseDate(tour.log,"DD/MM/YYYY") }}</li>
                                </ul>
                            </div>
                            <div class="col-lg-2 col-md-2">
                                <div class="booking_buttons">
                                    <a :href="'<?= Yii::app()->baseUrl; ?>/tourReservacion/view/' + tour.id_tourReservacion" class="btn_2" target="_blank">Ver detalle</a>
                                    <a href="#0" class="btn_3">Solicitar cancelación</a>
                                </div>
                            </div>
                        </div>
                        <!-- End row -->
                    </div>
                </section>

                <section id="section-5">
                    <?php $this->renderPartial('_pagos_facturacion'); ?>
                </section>
                <!-- End section 3 -->
            </div>
            <!-- End content -->

            <!-- Sign In Popup -->
            <div id="sign-in-dialog" class="zoom-anim-dialog mfp-hide">
                <div class="small-dialog-header">
                    <h3>Sign In</h3>
                </div>
                <form>
                    <div class="sign-in-wrapper">
                        <a href="#0" class="social_bt facebook">Login with Facebook</a>
                        <a href="#0" class="social_bt google">Login with Google</a>
                        <div class="divider"><span>Or</span></div>
                        <div class="form-group">
                            <label>Email</label>
                            <input type="email" class="form-control" name="email" id="email">
                            <i class="icon_mail_alt"></i>
                        </div>
                        <div class="form-group">
                            <label>Password</label>
                            <input type="password" class="form-control" name="password" id="password" value="">
                            <i class="icon_lock_alt"></i>
                        </div>
                        <div class="clearfix add_bottom_15">
                            <div class="checkboxes float-left">
                                <input id="remember-me" type="checkbox" name="check">
                                <label for="remember-me">Remember Me</label>
                            </div>
                            <div class="float-right"><a id="forgot" href="javascript:void(0);">Forgot Password?</a></div>
                        </div>
                        <div class="text-center"><input type="submit" value="Log In" class="btn_login"></div>
                        <div class="text-center">
                            Don’t have an account? <a href="javascript:void(0);">Sign up</a>
                        </div>
                        <div id="forgot_pw">
                            <div class="form-group">
                                <label>Please confirm login email below</label>
                                <input type="email" class="form-control" name="email_forgot" id="email_forgot">
                                <i class="icon_mail_alt"></i>
                            </div>
                            <p>You will receive an email containing a link allowing you to reset your password to a new preferred one.</p>
                            <div class="text-center"><input type="submit" value="Reset Password" class="btn_1"></div>
                        </div>
                    </div>
                </form>
                <!--form -->
            </div>
            <!-- /Sign In Popup -->
        </div>
        <!-- End tabs -->
    </div>
</main>
<!-- end container -->

<?php 
$buscar_nombre = ($_SESSION["searching"]) ? $_SESSION["searching"]["nombre"] : "" ;
Yii::app()->clientScript->registerScriptFile($assets .'/js/tabs.js', CClientScript::POS_END); 
Yii::app()->clientScript->registerScript('tabs', 'new CBPFWTabs(document.getElementById("tabs"));', CClientScript::POS_READY); 
Yii::app()->clientScript->registerScript('url', '
    var baseUrl = "'. Yii::app()->baseUrl .'";
    var rmt_url = "https://'. $_SERVER['SERVER_NAME'] . Yii::app()->baseUrl .'";
    var id_agencia = '. $_SESSION["agencia"]["id_agencia"] .';
    var tipo_usuario = "'. $_SESSION['tipoUsuario'] .'";', CClientScript::POS_HEAD);
Yii::app()->clientScript->registerScript('search', '
    app.search_pax_reserva="'.$buscar_nombre.'";
    ', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.24.0/moment.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://unpkg.com/vue-router/dist/vue-router.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.24.0/locale/es.js', CClientScript::POS_END);
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/vue/booking_list.js?v='. time(), CClientScript::POS_END);
?>