<div style="background: #eee; padding: 5px; margin-bottom: 15px;">
    <div class="form-row align-items-center">
        <div class="col-sm-2">
            <select class="form-control">
                <option value="" selected>Ordenar por fecha</option>
                <option value="now">Hoy</option>
                <option value="oldest">Más viejo</option>
                <option value="newest">Más reciente</option>
            </select>
        </div>
        <div class="col-sm-2">
            <input type="text" class="form-control" placeholder="Folio" autocomplete="off" v-model="search_idRecibo">
        </div>
    </div>
</div>
<div class="strip_booking" v-for="recibo in filteredReceipt.slice(0,30)">
    <div class="row">
        <div class="col-lg-2 col-md-2">
            <div class="date">
                <span class="month" style="background-color: #33ad85;" v-text="parseDate(recibo.log, 'MMM')"></span>
                <span class="day">
                    <strong style="color: #33ad85;">{{ parseDate(recibo.log, "DD") }}</strong>
                    {{ parseDate(recibo.log, "YYYY") }}
                </span>
            </div>
            <div class="text-center">
                <span v-if="recibo.estado == 'AP'" class="badge badge-info">Aplicado</span>
                <span v-else-if="recibo.estado == 'C'" class="badge badge-danger">Cancelado</span>
                <span v-else class="badge badge-success">Pagado</span>
            </div>
        </div>
        <div class="col-lg-6 col-md-5">
            <h3 class="tours_booking">$ {{ round(recibo.importe,2) }}
                <span>Agencia: {{ recibo.nombre_agencia }}</span>
                <br>
                <span><strong>Forma de Pago:</strong> {{ recibo.descripcion }}</span>
            </h3>
        </div>
        <div class="col-lg-2 col-md-3">
            <ul class="info_booking" style="font-size: 12px;">
                <li><strong>Folio</strong><br> {{ recibo.id_recibo }}</li><br>
                <li v-if="recibo.fecha_limite_factura!=null"><strong>Fecha Límite para facturar:</strong><br> {{ recibo.fecha_limite_factura }}</li>
            </ul>
        </div>
        <div class="col-lg-2 col-md-2">
            <div class="booking_buttons">
                <a :href="'https://www.rutamayatravel.com/reservaciones/sur3/pagos/GeneratePdf/idrecibo/' + recibo.id_recibo" class="btn_2" target="_blank">Ver recibo</a><br>
                <a v-if="cuenta_cfdi.includes(recibo.id_cuenta)==true && recibo.puede_facturar_fecha==1 && recibo.estado!='C'" :href="'<?= Yii::app()->baseUrl; ?>/facturacionCfdi/factura/idrecibo/' + recibo.id_recibo" class="btn_full">Facturar</a>
                <a href="">Descargar PDF</a> <br> <a href="">Descargar XML</a>
                <br>
            </div>
        </div>
    </div>
</div>