<style>
	/* Estilos generales */
	body {
		font-size: 12px;
	}

	.title {
		font-size: 16px;
		font-weight: bold;
	}

	.section-title {
		font-size: 16px;
		font-weight: bold;
		margin-bottom: 10px;
	}

	.confirmation-number {
		font-size: 14px;
		font-weight: bold;
	}

	.info-table {
		width: 100%;
		border: 1px solid #7ebdfb;
		padding: 16px;
		margin-bottom: 10px;
		border-radius: 15px;
	}

	.info-table td {
		/* padding: 5px; */
	}

	.details {
		font-size: 16px;
		margin-top: 10px;
		padding: 5px;
	}

	.policies,
	.important-info {
		font-size: 11px;
		margin-top: 20px;
		padding: 10px;
	}

	.contact-info {
		font-size: 12px;
		margin-top: 20px;
	}

	.datosReserva {
		line-height: 24px;
	}

	.datosEncabezados {
		font-weight: bold;
	}

	.text-center {
		text-align: center;
	}

	.text-r {
		text-align: right;
	}

	.fecha_reserva {
		font-size: 14px;
		font-weight: bold;
		text-transform: capitalize;
	}

	.w-100 {
		width: 100%;
	}
	.cont-fecha{
		float: right; 
		width: 30%; 
		text-align: right;
		border: 1px solid red;
		border-radius: 15px;
		padding: 12px;
	}
	.fecha-inicial{
		float: left;
		width: 49%;
	}
	.fecha-final{
		float: right;
		width: 49%; 
		border-left: 1px solid red;
	}

	.hr-uvac{
		color: #b4dff6;
		margin-top: 20px;
		margin-bottom: 20px;
	}
	.section-text{
		font-size: 12px;
	}
</style>

<div class="datosReserva w-100">
	<div style="float: left; width: 50%; line-height: 30px;">
		<div class="title"><?= $hotel->nombre_hotel ?></div>
		<div class="datosEncabezados"><?= $destino->name . ", " . $destino->destinationsCode0->name . ", " . $country->description ?></div>
		<div><span class="datosEncabezados">Titular de la reserva:</span> <?= $reservacion->nombre_cliente . " " . $reservacion->apellido_cliente ?></div>
	</div>
	<div class="cont-fecha">
		<?php setlocale(LC_TIME, 'es_ES.UTF-8'); ?>
        <div class="fecha-inicial text-center" >
            Check In <br><span class="fecha_reserva"><?= strftime('%d/%b/%Y', strtotime($reservacion->fecha_inicial)); ?></span>
        </div>
        <div class="fecha-final text-center">
            Check Out <br><span class="fecha_reserva"><?= strftime('%d/%b/%Y', strtotime($reservacion->fecha_final)); ?></span>
        </div>
	</div>
</div>
	

<br><br>

<!-- Información de la reserva -->
<?php foreach ($desglose as $ind => $habitacion) : ?>
<div class="info-table">
	<table width="100%">
		<tr>
			<td width="33%"><strong>Nombre de la habitación</strong></td>
			<td width="33%"><strong>Titular de la habitación</strong></td>
			<td width="33%"><strong>Número de pasajeros</strong></td>
		</tr>
		<tr>
			<td width="33%">
				<?= $habitacion->idtipohabitacion->tipo_habitacion; ?><br>
				<?= $reservacion->idTipoPlan->nombre ?><br>
				No. Confirmación: <b><?= $reservacion->code ?></b>
			</td>
			<td width="33%"><?= ReservacionDesglosePersona::model()->find('id_desglose = ' . $habitacion->id_desglose)->nombre; ?></td>
			<td width="33%"><?= $habitacion->num_adultos ?> Adultos <?= ($habitacion->num_ninios > 0) ? ', ' . $habitacion->num_ninios . "Niños"  : NULL ?> </td>
		</tr>
	</table>
</div>
<?php endforeach; ?>

<div class="details">
	<p>Ten presente que al momento del check-in debes presentar una identificación oficial, adultos y menores, además de este cupón impreso.</p>
	<p>Horarios de Check In y Check Out están sujetos a políticas de cada hotel.</p>
</div>

<!-- Teléfono de emergencia -->
<h4 class="section-title">Teléfono de Emergencia</h4>
<div class="contact-info">
	Estimado pasajero, si tiene alguna duda con su reservación favor de comunicarse al 2960931.
</div>

<hr class="hr-uvac">
<!-- Políticas del hotel -->
<h4 class="section-title">Políticas del Hotel</h4>

<div class="section-text">
	<p><?= $reservacion->politicas_cancelacion ?></p>
</div>

<!-- <hr class="hr-uvac"> -->

<!-- Información importante -->
<!-- <h4 class="section-title">Información Importante</h4>

<div class="section-text">
	<p>El hotel se encuentra en una excelente ubicación, con fácil acceso a las playas locales, tiendas y restaurantes. El servicio es todo incluido con acceso a restaurantes exclusivos...</p>
</div> -->