<section class="pt60 pb90 bgc-f7">
  <div class="container">
    <?php 
    // echo CJSON::encode($bookingDetail);
    ?>
    <div class="reservaRealizada my20">
      <i class="fa-solid fa-circle-check"></i>
      <h6>!Gracias por tu reserva!</h6>
    </div>
    <div class="row wrap wow fadeInUp" data-wow-delay="500ms" style="visibility: visible; animation-delay: 500ms; animation-name: fadeInUp;">
      <div class="col-lg-12">
        <div class="ps-widget bgc-white bdrs12 default-box-shadow2 p30 mb30 overflow-hidden position-relative">
          <div class="d-flex justify-content-between align-items-center">
            <h3 class="title fz20 mb30">Confirmación de reserva</h3>
            <p><b>Estatus: </b> <?= ($model->estatus == "R") ? '<span class="badge bg-success">Reservado</span>' : '<span class="badge bg-danger">Cancelado</span>' ?> </p>
          </div>

          <div class="d-flex justify-content-between">
            <div>
              <p class="fz14"><b>Folio: </b>#<?= $model->id_reservacion; ?></p>
              <p class="fz14"><b>Codigo de confirmación: </b>#<?= $model->code; ?></p>
            </div>
            <div>
            <p class="fz14"><b>Fecha de creación: </b><?= date('d/m/Y H:i:s', strtotime($model->log)); ?></p>
            <p class="fz14"><b>Fecha del servicio: </b><?= date("d/m/Y", strtotime("$model->fecha_inicial")); ?></p>
            </div>
          </div>

          <div class="row my20 justify-content-between">
            <div class="col-md-5">
              <h3 class="title fz16">Datos del pasajero</h3>
              <div>
                <p class="fz14"><b>Nombre:</b> <?= $model->nombre_cliente . " " . $model->apellido_cliente ?></p>
                <p class="fz14"><b>Correo:</b> <?= $model->email_cliente ?></p>
                <?php if ($model->tel_cliente) : ?>
                  <p class="fz14"><b>Teléfono:</b> <?= $model->tel_cliente ?></p>
                <?php endif; ?>
              </div>
            </div>
            <div class="col-md-5">
              <h3 class="title fz16">Datos del proveedor</h3>
              <div>
                <p class="fz14"><b>Proveedor: </b> <?= $bookingDetail['booking']['activities'][0]['providerInformation']['name'] ?></p>
                <p class="fz14"><b>Reservado y pagadero por: </b> <?= $bookingDetail['booking']['activities'][0]['supplier']['name'] . " REF: " . $bookingDetail['booking']['activities'][0]['supplier']['vatNumber'] ?></p>
              </div>
            </div>
          </div>

          <div class="row my20 justify-content-between">
            <div class="col-md-5">
              <h3 class="title fz16 mt30">Datos del servicio</h3>
                <div class="list-news-style d-flex mt20 mb20">
                  <div class="news-img flex-shrink-0">
                    <img src="<?= $model->picture; ?>" alt="<?= $model->actividad; ?>">
                  </div>
                  <div class="news-content flex-shrink-1 ms-3">
                    <p class="new-text mb0 fz14"><b><?= $model->actividad; ?></b></p>
                    <p class="new-text mb0 fz14"><?= $model->modalidad ?></p>
                    <p class="new-text mb0 fz14"><?= $model->destino ?></p>
                  </div>
                </div>
            </div>
            <div class="col-md-5">
                <?php
									if (!empty($reserv_desgloce) && $model->manual != 1) {
										$h = 1;
										$t = $desgloseReserva[2];
                    $num_adultos = 0;
                    $num_menores = 0;
                    $total_adultos = 0;
                    $total_menores = 0;
                    $total_reserva = 0;
										foreach ($reserv_desgloce as $reserv) {
											$num_adultos+= intval($reserv['num_adultos']);
											$num_adultos+= intval($reserv['num_menores']);

                      $total_adultos+= floatval($reserv['precio_adulto']);

											// echo "<td align='right'>$ " . number_format($reserv['precio_adulto'], 2) . "</td>";
											// echo "<td align='right'>$ " . number_format(($reserv['precio_adulto'] * $reserv['num_adultos']), 2) . "</td>";
											// echo "</tr> ";
											if ($reserv['num_menores'] > 0) {
												$num_menores+= intval($reserv['num_menores']);
                        $total_menores+= floatval($reserv['precio_ninio']);
												// echo "<td align='right'>$ " . number_format($reserv['precio_ninio'], 2) . "</td>";
												// echo "<td align='right'>$ " . number_format(($reserv['precio_ninio'] * $reserv['num_menores']), 2) . "</td>";
												// echo "</tr> ";
											}

											$h++;
										}
                    $total_reserva = $total_adultos + $total_menores;
									}
              ?>
              <h3 class="title fz16 mt30">Desglose del precio</h3>
              <p class="fz14">Adultos: <?= $num_adultos ?></p>
              <p class="fz14">Menores: <?= $num_menores ?></p>
              <p class="fz14">Total adultos: <?= number_format($total_adultos, 2) ?></p>
              <p class="fz14">Total menores: <?= number_format($total_menores, 2) ?></p>
              <p class="fz14"><b>Total de la reserva:</b> <?= number_format($total_reserva, 2) ?></p>
            </div>
          </div>

          <hr>
          <div class="text-end d-flex justify-content-end align-items-center">
          <?php if ($model->estatus != 'C') : ?>
            <form method="POST" action="<?= Yii::app()->createUrl("activities/cancelarReserva") ?>" class="form-style1">
              <input type="hidden" name="id_reservacion" value="<?= $model->id_reservacion ?>">
              <input type="hidden" name="cancellationFlag" value="CANCELLATION">
              <button class="ud-btn btn-thm" type="submit" onclick="return confirm('¿Seguro que quieres cancelar la reserva?')">Cancelar Reserva</button>    
            </form>
            <?php endif; ?>
            <?php if (isset($bookingDetail['booking']['activities'][0]['vouchers']) && count($bookingDetail['booking']['activities'][0]['vouchers']) > 0) : ?>
              <?php foreach ($bookingDetail['booking']['activities'][0]['vouchers'] as $key => $voucher) : ?>
                  <a target="_blank" class="ud-btn btn-white2 py10" href="<?= $voucher['url'] ?>">Descargar</a>
                <?php endforeach; ?>
              <?php else : ?>
              <a target="_blank" class="ud-btn btn-white2 py10" href="<?= Yii::app()->createUrl("activities/cupon", array('id' => $model->id_reservacion)) ?>">Descargar</a>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>