<?php
$this->breadcrumbs=array(
	UserModule::t('Users')=>array('/user'),
	UserModule::t('Manage'),
);

$this->menu=array(
    array('label'=>UserModule::t('Create User'), 'url'=>array('create')),
    array('label'=>UserModule::t('Manage Users'), 'url'=>array('/user/admin/admin'), 'visible'=>UserModule::isAdmin()),
    array('label'=>UserModule::t('Manage Profile Field'), 'url'=>array('/user/profileField/admin')),
    array('label'=>UserModule::t('List Users'), 'url'=>array('/user/user/index')),
);

?>

<div class="row">
    <div class="col-sm-12">
      <div class="panel panel-default">
		<div class="panel-heading bg-white">
          <h3><?php echo UserModule::t("Administrar usuarios"); ?></h3>
        </div>
        <div class="panel-body">
        <?php $this->widget('bootstrap.widgets.TbGridView', array(
            'id'=>'user-grid',
            'dataProvider'=>$model->search(),
            'filter'=>$model,
            'columns'=>array(
                array(
                    'name' => 'id',
                    'type'=>'raw',
                    'value' => 'CHtml::link(CHtml::encode($data->id),array("admin/update","id"=>$data->id))',
                ),
                array(
                    'name' => 'username',
                    'type'=>'raw',
                    'value' => 'CHtml::link(UHtml::markSearch($data,"username"),array("admin/view","id"=>$data->id))',
                ),
                array(
                    'name'=>'email',
                    'type'=>'raw',
                    'value'=>'CHtml::link(UHtml::markSearch($data,"email"), "mailto:".$data->email)',
                ),
                /*
                'id',
                'username',
                'email',
                'create_at',
                'lastvisit_at',
                */
                array(
                    'name'=>'superuser',
                    'value'=>'User::itemAlias("AdminStatus",$data->superuser)',
                    'filter'=>User::itemAlias("AdminStatus"),
                ),
                array(
                    'name'=>'status',
                    'value'=>'User::itemAlias("UserStatus",$data->status)',
                    'filter' => User::itemAlias("UserStatus"),
                ),
                array(
                    'class'=>'bootstrap.widgets.TbButtonColumn',
                    'template' => '{view} {update} {delete}',
                    'buttons' => array(
                          'view' => array(
                            'label'=> 'Ver',
                            'options'=>array(
                                'class'=>'btn btn-sm fa fa-eye view'
                            )
                        ),	
                                      'update' => array(
                            'label'=> 'Actualizar',
                            'options'=>array(
                                'class'=>'btn btn-sm fa fa-edit update'
                            )
                        ),
                        'delete' => array(
                            'label'=> 'Eliminar',
                            'options'=>array(
                                'class'=>'btn btn-sm fa fa-remove delete'
                            )
                        )
                    ),
                    'htmlOptions'=>array('style'=>''),
                ),
            ),
        )); ?>
		</div>
      </div>
    </div>
</div>