<?php

class RecoveryController extends Controller
{
	public $defaultAction = 'recovery';
	//public $layout='//layouts/recuperarpass';
	public $layout='//layouts/layout_login';
	
	/**
	 * Recovery password
	 */
	public function actionRecovery () {
		$form = new UserRecoveryForm;
		if (Yii::app()->user->id) {
		    	$this->redirect(Yii::app()->controller->module->returnUrl);
	    } else {
			$email = ((isset($_GET['email']))?$_GET['email']:'');
			$activkey = ((isset($_GET['activkey']))?$_GET['activkey']:'');
			if ($email&&$activkey) {
				$form2 = new UserChangePassword;
	    		$find = User::model()->notsafe()->findByAttributes(array('email'=>$email));
	    		if(isset($find)&&$find->activkey==$activkey) {
		    		if(isset($_POST['UserChangePassword'])) {
						$form2->attributes=$_POST['UserChangePassword'];
						if($form2->validate()) {
							$find->password = Yii::app()->controller->module->encrypting($form2->password);
							$find->activkey=Yii::app()->controller->module->encrypting(microtime().$form2->password);
							if ($find->status==0) {
								$find->status = 1;
							}
							$find->save();
							Yii::app()->user->setFlash('success','Nuevo contraseña guardada');
							$this->redirect(Yii::app()->user->loginUrl);
						}
					} 
					$this->render('changepassword',array('model'=>$form2));
	    		} else {
	    			Yii::app()->user->setFlash('error',UserModule::t("Incorrect recovery link."));
					$this->redirect(Yii::app()->controller->module->recoveryUrl);
	    		}
	    	} else {
		    	if(isset($_POST['UserRecoveryForm'])) {
		    		$form->attributes=$_POST['UserRecoveryForm'];
		    		if($form->validate()) {
		    			$user = User::model()->notsafe()->findbyPk($form->user_id);
						$activation_url = 'https://' . $_SERVER['HTTP_HOST'].$this->createUrl(implode(Yii::app()->controller->module->recoveryUrl),array("activkey" => $user->activkey, "email" => $user->email));
						
						$subject = UserModule::t("Ruta Maya Travel. Recuperación de contraseña",
		    					array(
		    						'{site_name}'=>Yii::app()->name,
		    					));
		    			$message = UserModule::t("<b>Ruta Maya Travel</b><br><br>Estimado usuario de agencia, solicitaste recuperar tu contraseña, para resetear tu contraseña te invitamos hacer clic en la siguiente dirección o copiar y pegarla en tu navegador 
		    				<a href='{activation_url}' target='_blank'>{activation_url}</a><br><br>Saludos, <br>{site_name}",
		    					array(
		    						'{site_name}'=>Yii::app()->name,
		    						'{activation_url}'=>$activation_url,
		    					));
						
		    			UserModule::sendMail($user->email,$subject,$message);
		    			
						Yii::app()->user->setFlash('info','Por favor verifica tu email y sigue las instrucciones.');
		    			$msg ="Por favor verifica tu email y sigue las instrucciones.";
		    			//$this->refresh();
		    		}
		    	}
	    		$this->render('recovery',array('model'=>$form, 'msg'=>$msg));
	    	}
	    }
	}

}