<?php

/**
 * This is the model class for table "{{vendor_code}}".
 *
 * The followings are the available columns in table '{{vendor_code}}':
 * @property integer $id_vendorCode
 * @property integer $id_cadena
 * @property string $zona
 * @property string $vendorCode
 *
 * The followings are the available model relations:
 * @property CadenaHotel $idCadena
 */
class VendorCode extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorCode the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{vendor_code}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_cadena, zona', 'required'),
			array('id_cadena', 'numerical', 'integerOnly'=>true),
			array('zona, vendorCode', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_vendorCode, id_cadena, zona, vendorCode', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idCadena' => array(self::BELONGS_TO, 'CadenaHotel', 'id_cadena'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_vendorCode' => 'Id Vendor Code',
			'id_cadena' => 'Id Cadena',
			'zona' => 'Zona',
			'vendorCode' => 'Vendor Code',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_vendorCode',$this->id_vendorCode);
		$criteria->compare('id_cadena',$this->id_cadena);
		$criteria->compare('zona',$this->zona,true);
		$criteria->compare('vendorCode',$this->vendorCode,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}