<?php



/**

 * This is the model class for table "{{usuarios}}".

 *

 * The followings are the available columns in table '{{usuarios}}':

 * @property string $id_usuario

 * @property string $nombre_usuario

 * @property string $email_usuario

 * @property string $clave_usuario

 * @property string $tipo_usuario

 * @property string $leng

 * @property integer $id_agencia

 * @property string $ip_publica

 * @property string $log

 * @property string $foto

 * @property string $tema

 * @property string $plugin

 * @property string $activacion

 * @property string $estatus

 * @property string $fecha_nacimiento

 *

 * The followings are the available model relations:

 * @property Users[] $users

 */

class Usuarios extends CActiveRecord

{

	/**

	 * Returns the static model of the specified AR class.

	 * @param string $className active record class name.

	 * @return Usuarios the static model class

	 */

	public static function model($className=__CLASS__)

	{

		return parent::model($className);

	}



	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{usuarios}}';

	}



	/**

	 * @return array validation rules for model attributes.

	 */

	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(

			array('nombre_usuario, email_usuario, clave_usuario, tipo_usuario', 'required'),

			array('id_agencia, id_hotel', 'numerical', 'integerOnly'=>true),

			array('nombre_usuario', 'length', 'max'=>255),

			array('clave_usuario, foto, activacion, aviso', 'length', 'max'=>255),

			array('email_usuario', 'length', 'max'=>128),

			array('tipo_usuario', 'length', 'max'=>5),

			array('leng, estatus', 'length', 'max'=>10),

			array('ip_publica', 'length', 'max'=>45),

			array('tema', 'length', 'max'=>50),

			array('plugin', 'length', 'max'=>70),

			array('fecha_nacimiento','safe'),

			// The following rule is used by search().

			// Please remove those attributes that should not be searched.

			array('id_usuario, nombre_usuario, email_usuario, clave_usuario, tipo_usuario, leng, id_agencia, id_hotel, ip_publica, log, foto, tema, plugin, activacion, estatus, fecha_nacimiento', 'safe', 'on'=>'search'),

		);

	}



	/**

	 * @return array relational rules.

	 */

	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array(

			'users' => array(self::HAS_MANY, 'Users', 'email'),

			'idAgencia' => array(self::BELONGS_TO, 'Agencias', 'id_agencia'),

			'idHotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),

			'profiles' => array(self::HAS_ONE, 'Profiles', 'user_id'),

		);

	}



	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			'id_usuario' => 'Id Usuario',

			'nombre_usuario' => 'Nombre',

			'email_usuario' => 'Email Usuario',

			'clave_usuario' => 'Clave Usuario',

			'tipo_usuario' => 'Tipo Usuario',

			'leng' => 'Leng',

			'id_agencia' => 'Agencia',

			'id_hotel'=> 'Hotel',

			'ip_publica' => 'Ip Publica',

			'log' => 'Log',

			'foto' => 'Foto',

			'tema' => 'Tema',

			'plugin' => 'Plugin',

			'activacion' => 'Activacion',

			'estatus' => 'Estatus',

			'fecha_nacimiento' => 'Fecha Nacimiento',

			'aviso' => 'Notificaciones',

		);

	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.

	 */

	public function search()

	{

		// Warning: Please modify the following code to remove attributes that

		// should not be searched.



		$criteria=new CDbCriteria;



		$criteria->compare('id_usuario',$this->id_usuario,true);

		$criteria->compare('nombre_usuario',$this->nombre_usuario,true);

		$criteria->compare('email_usuario',$this->email_usuario,true);

		$criteria->compare('clave_usuario',$this->clave_usuario,true);

		$criteria->compare('tipo_usuario',$this->tipo_usuario,true);

		$criteria->compare('leng',$this->leng,true);

		$criteria->compare('id_agencia',$this->id_agencia);

		$criteria->compare('ip_publica',$this->ip_publica,true);

		$criteria->compare('log',$this->log,true);

		$criteria->compare('foto',$this->foto,true);

		$criteria->compare('tema',$this->tema,true);

		$criteria->compare('plugin',$this->plugin,true);

		$criteria->compare('activacion',$this->activacion,true);

		$criteria->compare('estatus',$this->estatus,true);

		$criteria->compare('fecha_nacimiento',$this->fecha_nacimiento,true);



		return new CActiveDataProvider($this, array(

			'criteria'=>$criteria,

		));

	}

}