<?php

/**
 * This is the model class for table "{{tours_cotizaciones}}".
 *
 * The followings are the available columns in table '{{tours_cotizaciones}}':
 * @property integer $id_tours_cotizaciones
 * @property string $log
 * @property integer $id_agencia
 * @property string $id_usuario
 * @property integer $id_tour
 * @property string $fecha_viaje
 * @property string $nombre_cliente
 * @property integer $num_adultos
 * @property integer $num_menores
 * @property string $edad_menores
 * @property string $comentarios
 * @property string $archivo
 * @property string $importe
 * @property string $estatus
 * @property string $fecha_anexo
 * @property string $usuario_anexo
 *
 * The followings are the available model relations:
 * @property Agencias $idAgencia
 * @property Tour $idTour
 * @property Usuarios $idUsuario
 */
class ToursCotizaciones extends CActiveRecord
{

	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ToursCotizaciones the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{tours_cotizaciones}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_agencia, id_usuario, id_tour, fecha_viaje, num_adultos, num_menores, comentarios', 'required'),
			array('id_agencia, id_tour, num_adultos, num_menores', 'numerical', 'integerOnly'=>true),
			array('id_usuario', 'length', 'max'=>11),
			array('nombre_cliente, edad_menores, importe, usuario_anexo', 'length', 'max'=>50),
			array('comentarios', 'length', 'max'=>255),
			array('estatus', 'length', 'max'=>20),
			array('archivo, fecha_anexo', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_tours_cotizaciones, log, id_agencia, id_usuario, id_tour, fecha_viaje, nombre_cliente, num_adultos, num_menores, edad_menores, comentarios, archivo, importe, estatus, fecha_anexo, usuario_anexo', 'safe', 'on'=>'search'),

			//array('archivo', 'allowEmpty'=>true, 'on' => 'update'),
			array('archivo', 'file', 'types'=>'pdf', 'safe' => false, 'on'=>'create'),

			array('archivo', 'file', 'allowEmpty'=>true, 'on' => 'update'),

		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idAgencia' => array(self::BELONGS_TO, 'Agencias', 'id_agencia'),
			'idTour' => array(self::BELONGS_TO, 'Tour', 'id_tour'),
			'idUsuario' => array(self::BELONGS_TO, 'Usuarios', 'id_usuario'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_tours_cotizaciones' => 'Id Tours Cotizaciones',
			'log' => 'Log',
			'id_agencia' => 'Id Agencia',
			'id_usuario' => 'Id Usuario',
			'id_tour' => 'Id Tour',
			'fecha_viaje' => 'Fecha Viaje',
			'nombre_cliente' => 'Nombre Cliente',
			'num_adultos' => 'Num Adultos',
			'num_menores' => 'Num Menores',
			'edad_menores' => 'Edad Menores',
			'comentarios' => 'Comentarios',
			'archivo' => 'Archivo',
			'importe' => 'Importe',
			'estatus' => 'Estatus',
			'fecha_anexo' => 'Fecha Anexo',
			'usuario_anexo' => 'Usuario Anexo',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_tours_cotizaciones',$this->id_tours_cotizaciones);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('id_usuario',$this->id_usuario,true);
		$criteria->compare('id_tour',$this->id_tour);
		$criteria->compare('fecha_viaje',$this->fecha_viaje,true);
		$criteria->compare('nombre_cliente',$this->nombre_cliente,true);
		$criteria->compare('num_adultos',$this->num_adultos);
		$criteria->compare('num_menores',$this->num_menores);
		$criteria->compare('edad_menores',$this->edad_menores,true);
		$criteria->compare('comentarios',$this->comentarios,true);
		$criteria->compare('archivo',$this->archivo,true);
		$criteria->compare('importe',$this->importe,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('fecha_anexo',$this->fecha_anexo,true);
		$criteria->compare('usuario_anexo',$this->usuario_anexo,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}