<?php

/**
 * This is the model class for table "{{tour_tipo_habitacion}}".
 *
 * The followings are the available columns in table '{{tour_tipo_habitacion}}':
 * @property integer $id_tipo_habitacion
 * @property string $descripcion
 * @property integer $pax
 *
 * The followings are the available model relations:
 * @property TourTarifaDesglose[] $tourTarifaDesgloses
 */
class TourTipoHabitacion extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TourTipoHabitacion the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{tour_tipo_habitacion}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('descripcion, pax', 'required'),
			array('pax', 'numerical', 'integerOnly'=>true),
			array('descripcion', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_tipo_habitacion, descripcion, pax', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'tourTarifaDesgloses' => array(self::HAS_MANY, 'TourTarifaDesglose', 'id_tipo_habitacion'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_tipo_habitacion' => 'Id Tipo Habitacion',
			'descripcion' => 'Descripcion',
			'pax' => 'Pax',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_tipo_habitacion',$this->id_tipo_habitacion);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('pax',$this->pax);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}