<?php

/**
 * This is the model class for table "{{tour_tarifa_diasvalidos}}".
 *
 * The followings are the available columns in table '{{tour_tarifa_diasvalidos}}':
 * @property integer $id_diasvalidos
 * @property integer $id_tour_tarifa
 * @property integer $dia
 * @property string $log
 */
class TourTarifaDiasvalidos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TourTarifaDiasvalidos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{tour_tarifa_diasvalidos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_tour_tarifa, dia', 'required'),
			array('id_tour_tarifa, dia', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_diasvalidos, id_tour_tarifa, dia, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_diasvalidos' => 'Id Diasvalidos',
			'id_tour_tarifa' => 'Id Tour Tarifa',
			'dia' => 'Dia',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_diasvalidos',$this->id_diasvalidos);
		$criteria->compare('id_tour_tarifa',$this->id_tour_tarifa);
		$criteria->compare('dia',$this->dia);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}