<?php



/**

 * This is the model class for table "{{tour_tarifa_desglose}}".

 *

 * The followings are the available columns in table '{{tour_tarifa_desglose}}':

 * @property integer $id_tarifa_desglose

 * @property integer $id_tarifa

 * @property string $tipo

 * @property integer $edad_min

 * @property integer $edad_max

 * @property double $precio

 *

 * The followings are the available model relations:

 * @property TourTarifa $idTarifa

 */

class TourTarifaDesglose extends CActiveRecord

{

	/**

	 * Returns the static model of the specified AR class.

	 * @param string $className active record class name.

	 * @return TourTarifaDesglose the static model class

	 */

	public static function model($className=__CLASS__)

	{

		return parent::model($className);

	}



	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{tour_tarifa_desglose}}';

	}



	/**

	 * @return array validation rules for model attributes.

	 */

	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(

			array('id_tarifa, tipo, edad_min, edad_max, precio', 'required'),

			array('id_tarifa, edad_min, edad_max, id_tipo_habitacion', 'numerical', 'integerOnly'=>true),

			array('precio, neto, impuesto', 'numerical'),

			array('tipo', 'length', 'max'=>15),

			// The following rule is used by search().

			// Please remove those attributes that should not be searched.

			array('id_tarifa_desglose, id_tarifa, tipo, id_tipo_habitacion, edad_min, edad_max, precio', 'safe', 'on'=>'search'),

		);

	}



	/**

	 * @return array relational rules.

	 */

	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array(

			'idTarifa' => array(self::BELONGS_TO, 'TourTarifa', 'id_tarifa'),

			'idTipoHab' => array(self::BELONGS_TO, 'TourTipoHabitacion', 'id_tipo_habitacion'),

		);

	}



	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			'id_tarifa_desglose' => 'Id Tarifa Desglose',

			'id_tarifa' => 'Id Tarifa',

			'tipo' => 'Tipo',

			'edad_min' => 'Min',

			'edad_max' => 'Max',

			'precio' => 'Precio',

			'id_tipo_habitacion'=>'Habitación'

		);

	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.

	 */

	public function search()

	{

		// Warning: Please modify the following code to remove attributes that

		// should not be searched.



		$criteria=new CDbCriteria;



		$criteria->compare('id_tarifa_desglose',$this->id_tarifa_desglose);

		$criteria->compare('id_tarifa',$this->id_tarifa);

		$criteria->compare('tipo',$this->tipo,true);

		$criteria->compare('edad_min',$this->edad_min);

		$criteria->compare('edad_max',$this->edad_max);

		$criteria->compare('precio',$this->precio);

		$criteria->compare('id_tipo_habitacion',$this->id_tipo_habitacion);



		return new CActiveDataProvider($this, array(

			'criteria'=>$criteria,

		));

	}

}