<?php

/**
 * This is the model class for table "{{tour_tarifa}}".
 *
 * The followings are the available columns in table '{{tour_tarifa}}':
 * @property integer $id_tarifa
 * @property integer $id_tour
 * @property string $fecha_ini
 * @property string $fecha_fin
 * @property string $alias
 * @property string $codigo
 * @property string $descripcion
 * @property string $restricciones
 * @property double $comision_proveedor
 * @property double $comision_agencia
 * @property string $fecha_limite
 * @property integer $fecha_limite_dias
 * @property string $fecha_precompra
 * @property string $moneda
 * @property double $tasa_cambio
 * @property string $tipo_tarifa
 * @property double $iva
 * @property double $otros_impuestos
 * @property integer $estatus
 * @property string $precio
 *
 * The followings are the available model relations:
 * @property TourReservacion[] $tourReservacions
 * @property Tour $idTour
 * @property TourTarifaDesglose[] $tourTarifaDesgloses
 * @property TourTarifaFechas[] $tourTarifaFechases
 */
class TourTarifa extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TourTarifa the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{tour_tarifa}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_tour, fecha_ini, fecha_fin, alias, codigo, comision_proveedor, comision_agencia, fecha_limite, moneda, tipo_tarifa, iva, precio', 'required'),
			array('id_tour, fecha_limite_dias, estatus', 'numerical', 'integerOnly'=>true),
			array('comision_proveedor, comision_agencia, tasa_cambio, iva, otros_impuestos', 'numerical'),
			array('alias', 'length', 'max'=>100),
			array('codigo', 'length', 'max'=>25),
			array('moneda', 'length', 'max'=>3),
			array('tipo_tarifa', 'length', 'max'=>10),
			array('descripcion, restricciones, fecha_precompra', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_tarifa, id_tour, fecha_ini, fecha_fin, alias, codigo, descripcion, restricciones, comision_proveedor, comision_agencia, fecha_limite, fecha_limite_dias, fecha_precompra, moneda, tasa_cambio, tipo_tarifa, iva, otros_impuestos, estatus, precio', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'tourReservacions' => array(self::HAS_MANY, 'TourReservacion', 'id_tarifa'),
			'idTour' => array(self::BELONGS_TO, 'Tour', 'id_tour'),
			'tourTarifaDesgloses' => array(self::HAS_MANY, 'TourTarifaDesglose', 'id_tarifa'),
			'tourTarifaFechas' => array(self::HAS_MANY, 'TourTarifaFechas', 'id_tarifa'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_tarifa' => 'Id Tarifa',
			'id_tour' => 'Id Tour',
			'fecha_ini' => 'Fecha Ini',
			'fecha_fin' => 'Fecha Fin',
			'alias' => 'Alias',
			'codigo' => 'Codigo',
			'descripcion' => 'Descripcion',
			'restricciones' => 'Restricciones',
			'comision_proveedor' => 'Comision Proveedor',
			'comision_agencia' => 'Comision Agencia',
			'fecha_limite' => 'Fecha Limite',
			'fecha_limite_dias' => 'Fecha Limite Dias',
			'fecha_precompra' => 'Fecha Precompra',
			'moneda' => 'Moneda',
			'tasa_cambio' => 'Tasa Cambio',
			'tipo_tarifa' => 'Tipo Tarifa',
			'iva' => 'Iva',
			'otros_impuestos' => 'Otros Impuestos',
			'estatus' => 'Estatus',
			'precio' => 'Precio',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_tarifa',$this->id_tarifa);
		$criteria->compare('id_tour',$this->id_tour);
		$criteria->compare('fecha_ini',$this->fecha_ini,true);
		$criteria->compare('fecha_fin',$this->fecha_fin,true);
		$criteria->compare('alias',$this->alias,true);
		$criteria->compare('codigo',$this->codigo,true);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('restricciones',$this->restricciones,true);
		$criteria->compare('comision_proveedor',$this->comision_proveedor);
		$criteria->compare('comision_agencia',$this->comision_agencia);
		$criteria->compare('fecha_limite',$this->fecha_limite,true);
		$criteria->compare('fecha_limite_dias',$this->fecha_limite_dias);
		$criteria->compare('fecha_precompra',$this->fecha_precompra,true);
		$criteria->compare('moneda',$this->moneda,true);
		$criteria->compare('tasa_cambio',$this->tasa_cambio);
		$criteria->compare('tipo_tarifa',$this->tipo_tarifa,true);
		$criteria->compare('iva',$this->iva);
		$criteria->compare('otros_impuestos',$this->otros_impuestos);
		$criteria->compare('estatus',$this->estatus);
		$criteria->compare('precio',$this->precio,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}