<?php

/**
 * This is the model class for table "{{tarifa_diasvalidos}}".
 *
 * The followings are the available columns in table '{{tarifa_diasvalidos}}':
 * @property integer $id_tarifa_diavalido
 * @property integer $id_tarifa
 * @property integer $dia
 * @property string $log
 */
class TarifaDiasvalidos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TarifaDiasvalidos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{tarifa_diasvalidos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_tarifa, dia', 'required'),
			array('id_tarifa, dia', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_tarifa_diavalido, id_tarifa, dia, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_tarifa_diavalido' => 'Id Tarifa Diavalido',
			'id_tarifa' => 'Id Tarifa',
			'dia' => 'Dia',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_tarifa_diavalido',$this->id_tarifa_diavalido);
		$criteria->compare('id_tarifa',$this->id_tarifa);
		$criteria->compare('dia',$this->dia);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}