<?php

/**
 * This is the model class for table "{{tarifa_desglose}}".
 *
 * The followings are the available columns in table '{{tarifa_desglose}}':
 * @property string $id_tarifa_desglose
 * @property string $id_tarifa
 * @property string $id_tipo_habitacion
 * @property string $id_base_habitacion
 * @property double $precio_ninio
 * @property double $precio_adulto
 * @property double $precio_normal
 * @property double $precio_promo
 * @property integer $max_menores
 * @property string $log
 * @property integer $estatus
 */
class TarifaDesglose extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TarifaDesglose the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{tarifa_desglose}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_tarifa, id_tipo_habitacion, id_base_habitacion', 'required'),
			array('max_menores, estatus', 'numerical', 'integerOnly'=>true),
			array('precio_neto, precio_ninio, precio_adulto, precio_normal, precio_promo', 'numerical'),
			array('id_tarifa, id_tipo_habitacion, id_base_habitacion', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_tarifa_desglose, id_tarifa, id_tipo_habitacion, id_base_habitacion, precio_neto, precio_ninio, precio_adulto, precio_normal, precio_promo, max_menores, log, estatus', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'habitacionFechasbloqueadas' => array(self::HAS_MANY, 'FechasBloqueadas', 'id_tipo_habitacion', 'joinType'=>'LEFT JOIN', 'together'=>true),
			'idTipoHabitacion' => array(self::BELONGS_TO, 'TipoHabitaciones', 'id_tipo_habitacion'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_tarifa_desglose' => 'Id Tarifa Desglose',
			'id_tarifa' => 'Id Tarifa',
			'id_tipo_habitacion' => 'Id Tipo Habitacion',
			'id_base_habitacion' => 'Id Base Habitacion',
			'precio_neto' => 'Precio Neto',
			'precio_ninio' => 'Precio Ninio',
			'precio_adulto' => 'Precio Adulto',
			'precio_normal' => 'Precio Normal',
			'precio_promo' => 'Precio Promo',
			'max_menores' => 'Max Menores',
			'log' => 'Log',
			'estatus' => 'Estatus',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_tarifa_desglose',$this->id_tarifa_desglose,true);
		$criteria->compare('id_tarifa',$this->id_tarifa,true);
		$criteria->compare('id_tipo_habitacion',$this->id_tipo_habitacion,true);
		$criteria->compare('id_base_habitacion',$this->id_base_habitacion,true);
		$criteria->compare('precio_ninio',$this->precio_ninio);
		$criteria->compare('precio_adulto',$this->precio_adulto);
		$criteria->compare('precio_normal',$this->precio_normal);
		$criteria->compare('precio_promo',$this->precio_promo);
		$criteria->compare('max_menores',$this->max_menores);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('estatus',$this->estatus);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}