<?php



/**

 * This is the model class for table "{{tarifa}}".

 *

 * The followings are the available columns in table '{{tarifa}}':

 * @property string $id_tarifa

 * @property string $id_hotel

 * @property integer $id_tipo_plan

 * @property string $fecha_promo

 * @property string $fecha_inicial

 * @property string $fecha_final

 * @property integer $estatus

 * @property string $log

 * @property string $num_ninios_gratis

 * @property string $edad_maxima_ninio

 * @property string $edad_maxima_jr

 * @property string $precio

 * @property integer $promocontigua

 * @property string $nombre_tarifa

 * @property string $restricciones

 * @property string $moneda

 *

 * The followings are the available model relations:

 * @property TarifaDesglose[] $tarifaDesgloses

 */

class Tarifa extends CActiveRecord

{

	/**

	 * Returns the static model of the specified AR class.

	 * @param string $className active record class name.

	 * @return Tarifa the static model class

	 */

	public static function model($className=__CLASS__)

	{

		return parent::model($className);

	}



	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{tarifa}}';

	}



	/**

	 * @return array validation rules for model attributes.

	 */

	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(

			array('id_hotel, id_tipo_plan, fecha_inicial, fecha_final, hora_inicio, hora_final, iva, impuesto_hospedaje, comision, precio, nombre_tarifa, codigo', 'required'),

			array('id_tipo_plan, estatus, min_noches, promocontigua, id_combina, fecha_limite_dias, early_booking, release, id_logo, tipo_cambio, mostrar_conversion', 'numerical', 'integerOnly'=>true),

			array('iva, impuesto_hospedaje, comision, tasa_cambio', 'numerical'),

			array('id_hotel, num_ninios_gratis, edad_maxima_ninio, edad_maxima_jr, moneda', 'length', 'max'=>10),

			array('tipo_costo, precio', 'length', 'max'=>45),

			array('nombre_tarifa, codigo', 'length', 'max'=>255),

			array('fecha_promo_inicio, fecha_promo, fecha_limite, restricciones', 'safe'),

			// The following rule is used by search().

			// Please remove those attributes that should not be searched.

			array('id_tarifa, id_hotel, id_tipo_plan, fecha_promo_inicio, fecha_promo, fecha_inicial, fecha_final, hora_inicio, hora_final, estatus, log, num_ninios_gratis, edad_maxima_ninio, edad_maxima_jr, precio, promocontigua, id_combina, nombre_tarifa, codigo, restricciones, moneda, id_logo, tipo_cambio, tasa_cambio, mostrar_conversion', 'safe', 'on'=>'search'),

		);

	}



	/**

	 * @return array relational rules.

	 */

	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array(

			'tarifaDestino' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel', 'with'=>'DestinoLocal'),

			'tarifaHotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel', 'together'=>true),

			'tarifaPlan' => array(self::BELONGS_TO, 'Plan', 'id_tipo_plan'),

			'tarifaDesgloses' => array(self::HAS_MANY, 'TarifaDesglose', 'id_tarifa', 'together'=>true),

			'tarifaDesglosemenores' => array(self::HAS_MANY, 'DesgloseMenores', 'id_tarifa'),

			'tarifaDiasvalidos' => array(self::HAS_MANY, 'TarifaDiasvalidos', 'id_tarifa', 'joinType'=>'INNER JOIN', 'order'=>'dia', 'together'=>true),

			'tarifaFechasbloqueadas' => array(self::HAS_MANY, 'FechasBloqueadas', 'id_tarifa', 'joinType'=>'LEFT JOIN', 'together'=>true),

			'tarifaCierreFechas' => array(self::HAS_MANY, 'FechasBloqueadas', 'id_tarifa', 'joinType'=>'INNER JOIN'),

			'tarifaLogo' => array(self::BELONGS_TO, 'LogoEventos', 'id_logo'),

			'tarifaAgencias' => array(self::HAS_MANY, 'TarifaAgencia', 'id_tarifa'),

			'tarifaEstados' => array(self::HAS_MANY, 'TarifaEstados', 'id_tarifa'),

		);

	}



	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			'id_tarifa' => 'Id Tarifa',

			'id_hotel' => 'Id Hotel',

			'id_tipo_plan' => 'Tipo de Plan',

			'fecha_promo_inicio' => 'Inicio Precompra',

			'fecha_promo' => 'Final Precompra',

			'fecha_inicial' => 'Fecha Inicial',

			'fecha_final' => 'Fecha Final',

			'hora_inicio' => 'Hora Inicio',

			'hora_final' => 'Hora Final',

			'estatus' => 'Estatus',

			'log' => 'Log',

			'min_noches' => 'Mínimo Noches',

			'num_ninios_gratis' => 'Num Ninios Gratis',

			'edad_maxima_ninio' => 'Edad Maxima Ninio',

			'edad_maxima_jr' => 'Edad Maxima Jr',

			'iva' => 'Iva',

			'impuesto_hospedaje' => 'Impuesto Hospedaje',

			'comision' => 'Comisión',

			'tipo_costo' => 'Tipo Costo',

			'precio' => 'Tipo de Precio',

			'promocontigua' => 'Promoción Contigua',

			'id_combina' => 'Combina con',

			'nombre_tarifa' => 'Nombre Tarifa',

			'codigo' => 'Código',

			'fecha_limite_dias' => 'Fecha Límite por Días',

			'fecha_limite' => 'Fecha Límite',

			'early_booking' => 'Early Booking',

			'release' => 'Release',

			'restricciones' => 'Restricciones',

			'moneda' => 'Moneda',

			'id_logo' => 'Logo de Evento',

			'tipo_cambio' => 'Tipo de Cambio',

			'tasa_cambio' => 'Tasa de Cambio',

			'mostrar_conversion' => 'Mostrar Conversión',

		);

	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.

	 */

	public function search()

	{

		// Warning: Please modify the following code to remove attributes that

		// should not be searched.



		$criteria=new CDbCriteria;



		$criteria->compare('id_tarifa',$this->id_tarifa,true);

		$criteria->compare('id_hotel',$this->id_hotel,true);

		$criteria->compare('id_tipo_plan',$this->id_tipo_plan);

		$criteria->compare('fecha_promo_inicio',$this->fecha_promo_inicio,true);

		$criteria->compare('fecha_promo',$this->fecha_promo,true);

		$criteria->compare('fecha_inicial',$this->fecha_inicial,true);

		$criteria->compare('fecha_final',$this->fecha_final,true);

		$criteria->compare('estatus',$this->estatus);

		$criteria->compare('log',$this->log,true);

		$criteria->compare('num_ninios_gratis',$this->num_ninios_gratis,true);

		$criteria->compare('edad_maxima_ninio',$this->edad_maxima_ninio,true);

		$criteria->compare('edad_maxima_jr',$this->edad_maxima_jr,true);

		$criteria->compare('precio',$this->precio,true);

		$criteria->compare('promocontigua',$this->promocontigua);

		$criteria->compare('id_combina',$this->id_combina);

		$criteria->compare('nombre_tarifa',$this->nombre_tarifa,true);

		$criteria->compare('codigo',$this->codigo,true);

		$criteria->compare('restricciones',$this->restricciones,true);

		$criteria->compare('moneda',$this->moneda,true);

		$criteria->compare('id_logo',$this->id_logo);

		$criteria->compare('tipo_cambio',$this->tipo_cambio);

		$criteria->compare('tasa_cambio',$this->tasa_cambio);

		$criteria->compare('mostrar_conversion',$this->mostrar_conversion);



		return new CActiveDataProvider($this, array(

			'criteria'=>$criteria,

		));

	}

	

	public function tipoCambio($precio)

	{

		if($this->tipo_cambio != 0 && $this->mostrar_conversion == 1){

			if($this->tipo_cambio == 1){

				$precio = round($precio * $this->tarifaHotel->tipo_cambio,2);

			}else if($this->tipo_cambio == 2){

				$precio = round($precio * $this->tasa_cambio,2);

			}

		}

		

		return $precio;

	}

}