<?php

/**
 * This is the model class for table "{{suplemento}}".
 *
 * The followings are the available columns in table '{{suplemento}}':
 * @property string $id_suplemento
 * @property string $fecha_inicio
 * @property string $fecha_final
 * @property string $descripcion
 * @property double $importe
 * @property string $persona
 * @property integer $edad_min
 * @property integer $edad_max
 * @property string $id_tarifa
 *
 * The followings are the available model relations:
 * @property Tarifa $idTarifa
 */
class Suplemento extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Suplemento the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{suplemento}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('fecha_inicio, fecha_final, descripcion, importe, publico, persona, id_tarifa', 'required'),
			array('edad_min, edad_max', 'numerical', 'integerOnly'=>true),
			array('importe, publico', 'numerical'),
			array('persona', 'length', 'max'=>1),
			array('id_tarifa', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_suplemento, fecha_inicio, fecha_final, descripcion, importe, publico, persona, edad_min, edad_max, id_tarifa', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idTarifa' => array(self::BELONGS_TO, 'Tarifa', 'id_tarifa'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_suplemento' => 'Id Suplemento',
			'fecha_inicio' => 'Fecha Inicio',
			'fecha_final' => 'Fecha Final',
			'descripcion' => 'Descripcion',
			'importe' => 'Importe',
			'publico' => 'Público',
			'persona' => 'Persona',
			'edad_min' => 'Edad Min',
			'edad_max' => 'Edad Max',
			'id_tarifa' => 'Id Tarifa',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_suplemento',$this->id_suplemento,true);
		$criteria->compare('fecha_inicio',$this->fecha_inicio,true);
		$criteria->compare('fecha_final',$this->fecha_final,true);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('importe',$this->importe);
		$criteria->compare('publico',$this->publico);
		$criteria->compare('persona',$this->persona,true);
		$criteria->compare('edad_min',$this->edad_min);
		$criteria->compare('edad_max',$this->edad_max);
		$criteria->compare('id_tarifa',$this->id_tarifa,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}