<?php

/**
 * This is the model class for table "{{sucursales_estados}}".
 *
 * The followings are the available columns in table '{{sucursales_estados}}':
 * @property string $id_suc_estado
 * @property string $id_sucursal
 * @property integer $id_estado
 *
 * The followings are the available model relations:
 * @property Sucursales $idSucursal
 * @property Estadosmex $idEstado
 */
class SucursalesEstados extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SucursalesEstados the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{sucursales_estados}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_sucursal, id_estado', 'required'),
			array('id_estado', 'numerical', 'integerOnly'=>true),
			array('id_sucursal', 'length', 'max'=>11),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_suc_estado, id_sucursal, id_estado', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idSucursal' => array(self::BELONGS_TO, 'Sucursales', 'id_sucursal'),
			'idEstado' => array(self::BELONGS_TO, 'Estadosmex', 'id_estado'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_suc_estado' => 'Id Suc Estado',
			'id_sucursal' => 'Id Sucursal',
			'id_estado' => 'Id Estado',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_suc_estado',$this->id_suc_estado,true);
		$criteria->compare('id_sucursal',$this->id_sucursal,true);
		$criteria->compare('id_estado',$this->id_estado);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}