<?php

/**
 * This is the model class for table "tbl_solicitudes_desglose_tours".
 *
 * The followings are the available columns in table 'tbl_solicitudes_desglose_tours':
 * @property integer $id_solicitud_desglose
 * @property integer $id_solicitud
 * @property string $origen
 * @property string $destino
 * @property string $tipo
 * @property string $fecha_salida
 * @property string $fecha_regreso
 * @property integer $pax
 * @property string $categoria
 * @property string $tipo_privado
 * @property string $observaciones
 * @property integer $menores
 * @property integer $infantes
 * @property string $edad_menores
 * @property string $tipo_servicio
 * @property string $nombre_cliente
 * @property string $apellido_cliente
 * @property string $email_cliente
 * @property string $telefono_cliente
 */
class SolicitudesDesgloseTours extends CActiveRecord
{
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return 'tbl_solicitudes_desglose_tours';
    }

	public function getDbConnection()
	{
		return Yii::app()->db3;
	}

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('id_solicitud, fecha_salida, pax', 'required'),
            array('id_solicitud, pax, menores, infantes', 'numerical', 'integerOnly'=>true),
            array('origen, destino, nombre_cliente, apellido_cliente, email_cliente', 'length', 'max'=>255),
            array('tipo', 'length', 'max'=>8),
            array('categoria', 'length', 'max'=>10),
            array('tipo_privado', 'length', 'max'=>7),
            array('edad_menores', 'length', 'max'=>50),
            array('tipo_servicio', 'length', 'max'=>13),
            array('telefono_cliente', 'length', 'max'=>25),
            array('fecha_regreso, observaciones', 'safe'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id_solicitud_desglose, id_solicitud, origen, destino, tipo, fecha_salida, fecha_regreso, pax, categoria, tipo_privado, observaciones, menores, infantes, edad_menores, tipo_servicio, nombre_cliente, apellido_cliente, email_cliente, telefono_cliente', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id_solicitud_desglose' => 'Id Solicitud Desglose',
            'id_solicitud' => 'Id Solicitud',
            'origen' => 'Origen',
            'destino' => 'Destino',
            'tipo' => 'Tipo',
            'fecha_salida' => 'Fecha Salida',
            'fecha_regreso' => 'Fecha Regreso',
            'pax' => 'Pax',
            'categoria' => 'Categoria',
            'tipo_privado' => 'Tipo Privado',
            'observaciones' => 'Observaciones',
            'menores' => 'Menores',
            'infantes' => 'Infantes',
            'edad_menores' => 'Edad Menores',
            'tipo_servicio' => 'Tipo Servicio',
            'nombre_cliente' => 'Nombre Cliente',
            'apellido_cliente' => 'Apellido Cliente',
            'email_cliente' => 'Email Cliente',
            'telefono_cliente' => 'Telefono Cliente',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('id_solicitud_desglose',$this->id_solicitud_desglose);
        $criteria->compare('id_solicitud',$this->id_solicitud);
        $criteria->compare('origen',$this->origen,true);
        $criteria->compare('destino',$this->destino,true);
        $criteria->compare('tipo',$this->tipo,true);
        $criteria->compare('fecha_salida',$this->fecha_salida,true);
        $criteria->compare('fecha_regreso',$this->fecha_regreso,true);
        $criteria->compare('pax',$this->pax);
        $criteria->compare('categoria',$this->categoria,true);
        $criteria->compare('tipo_privado',$this->tipo_privado,true);
        $criteria->compare('observaciones',$this->observaciones,true);
        $criteria->compare('menores',$this->menores);
        $criteria->compare('infantes',$this->infantes);
        $criteria->compare('edad_menores',$this->edad_menores,true);
        $criteria->compare('tipo_servicio',$this->tipo_servicio,true);
        $criteria->compare('nombre_cliente',$this->nombre_cliente,true);
        $criteria->compare('apellido_cliente',$this->apellido_cliente,true);
        $criteria->compare('email_cliente',$this->email_cliente,true);
        $criteria->compare('telefono_cliente',$this->telefono_cliente,true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return SolicitudesDesgloseTours the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
}