<?php

/**
 * This is the model class for table "{{serv_def}}".
 *
 * The followings are the available columns in table '{{serv_def}}':
 * @property integer $id_serv_def
 * @property string $serv_def
 * @property string $descripcion
 * @property string $icono
 * @property integer $estatus
 * @property string $log
 */
class ServDef extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ServDef the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{serv_def}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('serv_def', 'required'),
			array('estatus', 'numerical', 'integerOnly'=>true),
			array('serv_def, descripcion, icono', 'length', 'max'=>255),
			array('log', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_serv_def, serv_def, descripcion, icono, estatus, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_serv_def' => 'Id Servicio',
			'serv_def' => 'Servicio',
			'descripcion' => 'Descripcion',
			'icono' => 'Icono',
			'estatus' => 'Estatus',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_serv_def',$this->id_serv_def);
		$criteria->compare('serv_def',$this->serv_def,true);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('icono',$this->icono,true);
		$criteria->compare('estatus',$this->estatus);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	public function estatus($x){
		switch($x){
			case 0: $y="Inactivo"; break;
			case 1: $y="Activo"; break;
		}
		return $y;
	}
}