<?php

/**
 * This is the model class for table "tbl_secciones".
 *
 * The followings are the available columns in table 'tbl_secciones':
 * @property integer $id
 * @property string $secciones
 * @property string $contenido
 * @property string $custom_css
 * @property string $custom_js
 * @property string $custom_url
 * @property string $creado
 * @property integer $estatus
 * @property integer $posicion
 * @property integer $id_subseccion
 */
class Secciones extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Secciones the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function getDbConnection()
	{
		return Yii::app()->db2;
	}
	
	public function tableName()
	{
		return 'tbl_secciones';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('secciones', 'required'),
			array('estatus, posicion, id_subseccion', 'numerical', 'integerOnly' => true),
			array('secciones', 'length', 'max' => 255),
			array('contenido, custom_css, custom_js, custom_url', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, secciones,  contenido, custom_css, custom_js, custom_url , creado, estatus, posicion, id_subseccion', 'safe', 'on' => 'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'subsecciones' => array(self::HAS_MANY, 'Subsecciones', 'id_seccion'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'secciones' => 'Secciones',
			'contenido' => 'Contenido',
			'custom_css' => 'Css Personalizado',
			'custom_js' => 'Js Personalizado',
			'custom_url' => 'URL',
			'creado' => 'Creado',
			'estatus' => 'Estatus',
			'posicion' => 'Posicion',
			'id_subseccion' => 'Id Subseccion',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('secciones', $this->secciones, true);
		$criteria->compare('contenido', $this->contenido, true);
		$criteria->compare('custom_css', $this->custom_css, true);
		$criteria->compare('custom_js', $this->custom_js, true);
		$criteria->compare('custom_url', $this->custom_url, true);
		$criteria->compare('creado', $this->creado, true);
		$criteria->compare('estatus', $this->estatus);
		$criteria->compare('posicion', $this->posicion);
		$criteria->compare('id_subseccion', $this->id_subseccion);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}
}
