<?php

/**
 * This is the model class for table "tbl_seccion".
 *
 * The followings are the available columns in table 'tbl_seccion':
 * @property integer $id
 * @property string $secciones
 * @property string $foto_destacada
 * @property string $contenido
 * @property string $custom_css
 * @property string $custom_js
 * @property string $custom_url
 * @property string $creado
 * @property integer $estatus
 *
 * The followings are the available model relations:
 * @property SeccionMenu[] $seccionMenus
 */
class Seccion extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_seccion';
	}
	public function getDbConnection()
	{
		return Yii::app()->db3;
	}
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('secciones, creado', 'required'),
			array('estatus', 'numerical', 'integerOnly' => true),
			array('secciones', 'length', 'max' => 255),
			array('foto_destacada, contenido, custom_css, custom_js, custom_url', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, secciones, foto_destacada, contenido, custom_css, custom_js, custom_url, creado, estatus', 'safe', 'on' => 'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'seccionMenus' => array(self::HAS_MANY, 'SeccionMenu', 'id_seccion'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'secciones' => 'Nombre de Sección',
			'foto_destacada' => 'Foto de portada',
			'contenido' => 'Contenido de la Sección',
			'custom_css' => 'Estilos personalizados',
			'custom_js' => 'JavaScripts personalizados',
			'custom_url' => 'Dirección URL personalizada',
			'creado' => 'Fecha de Creación',
			'estatus' => 'Estatus',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('secciones', $this->secciones, true);
		$criteria->compare('foto_destacada', $this->foto_destacada, true);
		$criteria->compare('contenido', $this->contenido, true);
		$criteria->compare('custom_css', $this->custom_css, true);
		$criteria->compare('custom_js', $this->custom_js, true);
		$criteria->compare('custom_url', $this->custom_url, true);
		$criteria->compare('creado', $this->creado, true);
		$criteria->compare('estatus', $this->estatus);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Seccion the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}
}
