<?php

/**
 * This is the model class for table "tbl_reservaciones_paynet".
 *
 * The followings are the available columns in table 'tbl_reservaciones_paynet':
 * @property integer $id
 * @property integer $id_agencia
 * @property integer $id_reservacion
 * @property string $url_pdf
 * @property string $estatus
 * @property string $log
 */
class ReservacionesPaynet extends CActiveRecord
{
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return 'tbl_reservaciones_paynet';
    }

	public function getDbConnection()
	{
		return Yii::app()->db3;
	}

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('id_agencia, id_reservacion', 'numerical', 'integerOnly'=>true),
            array('url_pdf', 'length', 'max'=>255),
            array('estatus', 'length', 'max'=>25),
            array('log', 'safe'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, id_agencia, id_reservacion, url_pdf, estatus, log', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'id_agencia' => 'Id Agencia',
            'id_reservacion' => 'Id Reservacion',
            'url_pdf' => 'Url Pdf',
            'estatus' => 'Estatus',
            'log' => 'Log',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('id',$this->id);
        $criteria->compare('id_agencia',$this->id_agencia);
        $criteria->compare('id_reservacion',$this->id_reservacion);
        $criteria->compare('url_pdf',$this->url_pdf,true);
        $criteria->compare('estatus',$this->estatus,true);
        $criteria->compare('log',$this->log,true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return ReservacionesPaynet the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
}