<?php

/**
 * This is the model class for table "rentasv_reservaciones_anuncio".
 *
 * The followings are the available columns in table 'rentasv_reservaciones_anuncio':
 * @property integer $id_Reserva
 * @property integer $id_anuncio
 * @property string $titulo_anuncio
 * @property integer $reservado_por
 * @property string $fecha_inicio
 * @property string $fecha_fin
 * @property integer $cantidad_huespedes
 * @property string $estado_reserva
 * @property string $metodo_pago
 * @property string $detalles_pago
 * @property string $tarifa_por_noche
 * @property string $tarifa_de_limpieza
 * @property string $tarifa_de_servicio
 * @property string $costo_total
 * @property string $correo
 * @property string $telefono
 * @property string $fecha_creacion
 * @property string $fecha_modificacion
 *
 * The followings are the available model relations:
 * @property RentasvAnuncios $idAnuncio
 */
class RentasvReservacionesAnuncio extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'rentasv_reservaciones_anuncio';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_anuncio, reservado_por, fecha_inicio, fecha_fin, estado_reserva, metodo_pago, tarifa_por_noche, tarifa_de_limpieza, costo_total, fecha_creacion, fecha_modificacion', 'required'),
			array('id_anuncio, reservado_por, cantidad_huespedes', 'numerical', 'integerOnly'=>true),
			array('titulo_anuncio, correo', 'length', 'max'=>255),
			array('estado_reserva, telefono', 'length', 'max'=>50),
			array('metodo_pago', 'length', 'max'=>100),
			array('tarifa_por_noche, tarifa_de_limpieza, tarifa_de_servicio, costo_total', 'length', 'max'=>10),
			array('detalles_pago', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id_Reserva, id_anuncio, titulo_anuncio, reservado_por, fecha_inicio, fecha_fin, cantidad_huespedes, estado_reserva, metodo_pago, detalles_pago, tarifa_por_noche, tarifa_de_limpieza, tarifa_de_servicio, costo_total, correo, telefono, fecha_creacion, fecha_modificacion', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idAnuncio' => array(self::BELONGS_TO, 'RentasvAnuncios', 'id_anuncio'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_Reserva' => 'Id Reserva',
			'id_anuncio' => 'Id Anuncio',
			'titulo_anuncio' => 'Titulo Anuncio',
			'reservado_por' => 'Reservado Por',
			'fecha_inicio' => 'Fecha Inicio',
			'fecha_fin' => 'Fecha Fin',
			'cantidad_huespedes' => 'Cantidad Huespedes',
			'estado_reserva' => 'Estado Reserva',
			'metodo_pago' => 'Metodo Pago',
			'detalles_pago' => 'Detalles Pago',
			'tarifa_por_noche' => 'Tarifa Por Noche',
			'tarifa_de_limpieza' => 'Tarifa De Limpieza',
			'tarifa_de_servicio' => 'Tarifa De Servicio',
			'costo_total' => 'Costo Total',
			'correo' => 'Correo',
			'telefono' => 'Telefono',
			'fecha_creacion' => 'Fecha Creacion',
			'fecha_modificacion' => 'Fecha Modificacion',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_Reserva',$this->id_Reserva);
		$criteria->compare('id_anuncio',$this->id_anuncio);
		$criteria->compare('titulo_anuncio',$this->titulo_anuncio,true);
		$criteria->compare('reservado_por',$this->reservado_por);
		$criteria->compare('fecha_inicio',$this->fecha_inicio,true);
		$criteria->compare('fecha_fin',$this->fecha_fin,true);
		$criteria->compare('cantidad_huespedes',$this->cantidad_huespedes);
		$criteria->compare('estado_reserva',$this->estado_reserva,true);
		$criteria->compare('metodo_pago',$this->metodo_pago,true);
		$criteria->compare('detalles_pago',$this->detalles_pago,true);
		$criteria->compare('tarifa_por_noche',$this->tarifa_por_noche,true);
		$criteria->compare('tarifa_de_limpieza',$this->tarifa_de_limpieza,true);
		$criteria->compare('tarifa_de_servicio',$this->tarifa_de_servicio,true);
		$criteria->compare('costo_total',$this->costo_total,true);
		$criteria->compare('correo',$this->correo,true);
		$criteria->compare('telefono',$this->telefono,true);
		$criteria->compare('fecha_creacion',$this->fecha_creacion,true);
		$criteria->compare('fecha_modificacion',$this->fecha_modificacion,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return RentasvReservacionesAnuncio the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
