<?php

/**
 * This is the model class for table "rentasv_imagenes".
 *
 * The followings are the available columns in table 'rentasv_imagenes':
 * @property integer $id_imagen
 * @property integer $id_espacio
 * @property string $url
 *
 * The followings are the available model relations:
 * @property RentasvAnuncios[] $rentasvAnuncioses
 * @property RentasvDatosDeTuEspacio $idEspacio
 */
class RentasvImagenes extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'rentasv_imagenes';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_espacio', 'numerical', 'integerOnly'=>true),
			array('url', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id_imagen, id_espacio, url', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'rentasvAnuncioses' => array(self::MANY_MANY, 'RentasvAnuncios', 'rentasv_anuncio_imagen(id_imagen, id_anuncio)'),
			'idEspacio' => array(self::BELONGS_TO, 'RentasvDatosDeTuEspacio', 'id_espacio'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_imagen' => 'Id Imagen',
			'id_espacio' => 'Id Espacio',
			'url' => 'Url',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_imagen',$this->id_imagen);
		$criteria->compare('id_espacio',$this->id_espacio);
		$criteria->compare('url',$this->url,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return RentasvImagenes the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
