<?php

/**
 * This is the model class for table "rentasv_datos_de_tu_espacio".
 *
 * The followings are the available columns in table 'rentasv_datos_de_tu_espacio':
 * @property integer $id_espacio
 * @property string $titulo
 * @property string $descripcion
 * @property string $precio
 *
 * The followings are the available model relations:
 * @property RentasvAnuncios[] $rentasvAnuncioses
 * @property RentasvImagenes[] $rentasvImagenes
 */
class RentasvDatosDeTuEspacio extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'rentasv_datos_de_tu_espacio';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('titulo, descripcion, precio', 'required'),
			array('titulo', 'length', 'max'=>255),
			array('precio', 'length', 'max'=>10),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id_espacio, titulo, descripcion, precio', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'rentasvAnuncioses' => array(self::HAS_MANY, 'RentasvAnuncios', 'id_espacio'),
			'rentasvImagenes' => array(self::HAS_MANY, 'RentasvImagenes', 'id_espacio'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_espacio' => 'Id Espacio',
			'titulo' => 'Titulo',
			'descripcion' => 'Descripcion',
			'precio' => 'Precio',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_espacio',$this->id_espacio);
		$criteria->compare('titulo',$this->titulo,true);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('precio',$this->precio,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return RentasvDatosDeTuEspacio the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
