<?php

/**
 * This is the model class for table "rentas_anuncios".
 *
 * The followings are the available columns in table 'rentas_anuncios':
 * @property integer $id_anuncio
 * @property string $titulo
 * @property string $descripcion
 * @property integer $camas
 * @property integer $banios
 * @property integer $habitaciones
 * @property double $precio
 */
class RentasAnuncios extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'rentas_anuncios';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('titulo, descripcion, precio', 'required'),
			array('camas, banios, habitaciones', 'numerical', 'integerOnly'=>true),
			array('precio', 'numerical'),
			array('titulo', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id_anuncio, titulo, descripcion, camas, banios, habitaciones, precio', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_anuncio' => 'ID',
			'titulo' => 'TÍtulo',
			'descripcion' => 'Descripción',
			'camas' => 'Camas',
			'banios' => 'Baños',
			'habitaciones' => 'Habitaciones',
			'precio' => 'Precio',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_anuncio',$this->id_anuncio);
		$criteria->compare('titulo',$this->titulo,true);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('camas',$this->camas);
		$criteria->compare('banios',$this->banios);
		$criteria->compare('habitaciones',$this->habitaciones);
		$criteria->compare('precio',$this->precio);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return RentasAnuncios the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
