<?php



/**

 * This is the model class for table "{{recibo}}".

 *

 * The followings are the available columns in table '{{recibo}}':

 * @property integer $id_recibo

 * @property integer $id_tipo

 * @property integer $referencia

 * @property integer $id_banco

 * @property integer $id_planpago

 * @property integer $tarjeta

 * @property double $importe

 * @property string $log

 * @property integer $id_user

 * @property integer $id_cuenta

 * @property double $comision

 * @property string $estado

 *

 * The followings are the available model relations:

 * @property Users $idUser

 * @property TipoPago $idTipo

 * @property Banco $idBanco

 * @property PlanPago $idPlanpago

 */

class Recibo extends CActiveRecord

{

	/**

	 * Returns the static model of the specified AR class.

	 * @param string $className active record class name.

	 * @return Recibo the static model class

	 */

	public static function model($className=__CLASS__)

	{

		return parent::model($className);

	}



	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{recibo}}';

	}



	/**

	 * @return array validation rules for model attributes.

	 */

	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(

			array('id_tipo, importe, id_user', 'required'),

			array('id_tipo, id_banco, id_planpago, tarjeta, id_agencia, id_user, id_cuenta, revisado', 'numerical', 'integerOnly'=>true),

			array('importe, comision', 'numerical'),

			array('cliente, referencia', 'length', 'max'=>100),

			array('estado', 'length', 'max'=>2),

			array('comprobante, motivo', 'length', 'max'=>255),
			array('observaciones', 'safe'),
			// The following rule is used by search().

			// Please remove those attributes that should not be searched.

			array('id_recibo, id_tipo, referencia, id_banco, id_planpago, tarjeta, importe, log, id_agencia, id_user, id_cuenta, comision, observaciones, estado, revisado', 'safe', 'on'=>'search'),

		);

	}



	/**

	 * @return array relational rules.

	 */

	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array(
		
			'idAgencia' => array(self::BELONGS_TO, 'Agencias', 'id_agencia'),

			'idUser' => array(self::BELONGS_TO, 'Users', 'id_user'),

			'idTipo' => array(self::BELONGS_TO, 'TipoPago', 'id_tipo'),

			'idBanco' => array(self::BELONGS_TO, 'Banco', 'id_banco'),

			'idPlanpago' => array(self::BELONGS_TO, 'PlanPago', 'id_planpago'),

		);

	}



	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			'id_recibo' => 'Id Recibo',

			'id_tipo' => 'Tipo de Pago',

			'cliente' => 'Cuenta Habiente',

			'referencia' => 'Referencia',

			'id_banco' => 'Banco',

			'id_planpago' => 'Plan de Pago',

			'tarjeta' => '4 D&iacute;gitos',

			'importe' => 'Monto a Pagar',

			'log' => 'Log',
			
			'id_agencia' => 'Agencia',

			'id_user' => 'Elaboró',

			'id_cuenta' => 'Cuenta',

			'comision' => 'Comision',

			'estado' => 'Estado',

			'observaciones' => 'Observaciones',

			'comprobante' => 'Comprobante',
			
			'motivo' => 'Motivo',
			
			'revisado' => 'Revisado',
		);

	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.

	 */

	public function search()

	{

		// Warning: Please modify the following code to remove attributes that

		// should not be searched.



		$criteria=new CDbCriteria;



		$criteria->compare('id_recibo',$this->id_recibo);

		$criteria->compare('id_tipo',$this->id_tipo);

		$criteria->compare('referencia',$this->referencia);

		$criteria->compare('id_banco',$this->id_banco);

		$criteria->compare('id_planpago',$this->id_planpago);

		$criteria->compare('tarjeta',$this->tarjeta);

		$criteria->compare('importe',$this->importe);

		$criteria->compare('log',$this->log,true);

		$criteria->compare('id_user',$this->id_user);

		$criteria->compare('id_cuenta',$this->id_cuenta);

		$criteria->compare('comision',$this->comision);

		$criteria->compare('estado',$this->estado,true);



		return new CActiveDataProvider($this, array(

			'criteria'=>$criteria,

		));

	}

}