<?php

/**
 * This is the model class for table "{{promociones_especiales}}".
 *
 * The followings are the available columns in table '{{promociones_especiales}}':
 * @property integer $id_promociones_especiales
 * @property integer $id_hotel
 * @property double $comision_agencia
 * @property string $booking_window_start
 * @property string $booking_window_end
 * @property string $travel_window_start
 * @property string $travel_window_end
 * @property integer $id_user
 * @property string $log
 */
class PromocionesEspeciales extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{promociones_especiales}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_hotel, comision_agencia, booking_window_start, booking_window_end, id_user', 'required'),
			array('id_hotel, id_user', 'numerical', 'integerOnly'=>true),
			array('comision_agencia', 'numerical'),
			array('travel_window_start, travel_window_end, log', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id_promociones_especiales, id_hotel, comision_agencia, booking_window_start, booking_window_end, travel_window_start, travel_window_end, id_user, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_promociones_especiales' => 'ID',
			'id_hotel' => 'Hotel',
			'comision_agencia' => 'Comisión Agencia',
			'booking_window_start' => 'Booking Window Inicio',
			'booking_window_end' => 'Booking Window Fin',
			'travel_window_start' => 'Travel Window Inicio',
			'travel_window_end' => 'Travel Window Fin',
			'id_user' => 'Usuario',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_promociones_especiales',$this->id_promociones_especiales);
		$criteria->compare('id_hotel',$this->id_hotel);
		$criteria->compare('comision_agencia',$this->comision_agencia);
		$criteria->compare('booking_window_start',$this->booking_window_start,true);
		$criteria->compare('booking_window_end',$this->booking_window_end,true);
		$criteria->compare('travel_window_start',$this->travel_window_start,true);
		$criteria->compare('travel_window_end',$this->travel_window_end,true);
		$criteria->compare('id_user',$this->id_user);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return PromocionesEspeciales the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}