<?php



/**

 * This is the model class for table "{{plan}}".

 *

 * The followings are the available columns in table '{{plan}}':

 * @property integer $id_plan

 * @property string $nombre

 * @property integer $tipo_validacion

 *

 * The followings are the available model relations:

 * @property PlanHotel[] $planHotels

 */

class Plan extends CActiveRecord

{

	/**

	 * Returns the static model of the specified AR class.

	 * @param string $className active record class name.

	 * @return Plan the static model class

	 */

	public static function model($className=__CLASS__)

	{

		return parent::model($className);

	}



	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{plan}}';

	}



	/**

	 * @return array validation rules for model attributes.

	 */

	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(

			array('nombre, tipo_validacion', 'required'),

			array('tipo_validacion', 'numerical', 'integerOnly'=>true),

			array('nombre,codeTS', 'length', 'max'=>50),

			// The following rule is used by search().

			// Please remove those attributes that should not be searched.

			array('id_plan, nombre, tipo_validacion,codeTS', 'safe', 'on'=>'search'),

		);

	}



	/**

	 * @return array relational rules.

	 */

	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array(

			'planHotels' => array(self::HAS_MANY, 'PlanHotel', 'id_plan'),

		);

	}



	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			'id_plan' => 'Id Plan',

			'nombre' => 'Nombre',

			'codeTS' => 'Codigo Travel Solution',

			'tipo_validacion' => 'Tipo Validacion',

		);

	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.

	 */

	public function search()

	{

		// Warning: Please modify the following code to remove attributes that

		// should not be searched.



		$criteria=new CDbCriteria;



		$criteria->compare('id_plan',$this->id_plan);

		$criteria->compare('nombre',$this->nombre,true);

		$criteria->compare('tipo_validacion',$this->tipo_validacion);

		$criteria->compare('codeTS',$this->codeTS);
		



		return new CActiveDataProvider($this, array(

			'criteria'=>$criteria,

		));

	}

} 