<?php

/**
 * This is the model class for table "{{pasarelas_agencias}}".
 *
 * The followings are the available columns in table '{{pasarelas_agencias}}':
 * @property integer $id_pasarela_agencia
 * @property integer $id_tipo_pasarela
 * @property integer $id_agencia
 * @property string $secret_key
 * @property string $secret_key_sandbox
 * @property string $public_key
 * @property string $public_key_sandbox
 * @property string $sdk_url
 * @property string $client_id
 * @property string $client_id_sandbox
 * @property string $key_decrypt
 * @property integer $ambiente
 * @property double $max_cant_venta
 * @property string $log
 * @property integer $estatus
 *
 * The followings are the available model relations:
 * @property Agencias $idAgencia
 * @property TiposPasarelas $idTipoPasarela
 */
class PasarelasAgencias extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{pasarelas_agencias}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_tipo_pasarela, id_agencia, log', 'required'),
			array('id_tipo_pasarela, id_agencia, ambiente, estatus', 'numerical', 'integerOnly'=>true),
			array('max_cant_venta', 'numerical'),
			array('secret_key, secret_key_sandbox, public_key, public_key_sandbox, sdk_url, client_id, client_id_sandbox, key_decrypt', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id_pasarela_agencia, id_tipo_pasarela, id_agencia, secret_key, secret_key_sandbox, public_key, public_key_sandbox, sdk_url, client_id, client_id_sandbox, key_decrypt, ambiente, max_cant_venta, log, estatus', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idAgencia' => array(self::BELONGS_TO, 'Agencias', 'id_agencia'),
			'idTipoPasarela' => array(self::BELONGS_TO, 'TiposPasarelas', 'id_tipo_pasarela'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_pasarela_agencia' => 'Id Pasarela Agencia',
			'id_tipo_pasarela' => 'Id Tipo Pasarela',
			'id_agencia' => 'Id Agencia',
			'secret_key' => 'Secret Key',
			'secret_key_sandbox' => 'Secret Key Sandbox',
			'public_key' => 'Public Key',
			'public_key_sandbox' => 'Public Key Sandbox',
			'sdk_url' => 'Sdk Url',
			'client_id' => 'Client',
			'client_id_sandbox' => 'Client Id Sandbox',
			'key_decrypt' => 'Key Decrypt',
			'ambiente' => '0 = SANDBOX | 1 = PRODUCCION',
			'max_cant_venta' => 'Max Cant Venta',
			'log' => 'Log',
			'estatus' => 'Estatus',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_pasarela_agencia',$this->id_pasarela_agencia);
		$criteria->compare('id_tipo_pasarela',$this->id_tipo_pasarela);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('secret_key',$this->secret_key,true);
		$criteria->compare('secret_key_sandbox',$this->secret_key_sandbox,true);
		$criteria->compare('public_key',$this->public_key,true);
		$criteria->compare('public_key_sandbox',$this->public_key_sandbox,true);
		$criteria->compare('sdk_url',$this->sdk_url,true);
		$criteria->compare('client_id',$this->client_id,true);
		$criteria->compare('client_id_sandbox',$this->client_id_sandbox,true);
		$criteria->compare('key_decrypt',$this->key_decrypt,true);
		$criteria->compare('ambiente',$this->ambiente);
		$criteria->compare('max_cant_venta',$this->max_cant_venta);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('estatus',$this->estatus);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return PasarelasAgencias the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
