<?php

/**
 * This is the model class for table "{{ordenes_pago}}".
 *
 * The followings are the available columns in table '{{ordenes_pago}}':
 * @property integer $id_orden_pago
 * @property string $id_hotel
 * @property double $importe
 * @property integer $id_tipo
 * @property integer $id_cuenta
 * @property integer $no_referencia
 * @property integer $id_user
 * @property string $fecha
 * @property string $estado
 *
 * The followings are the available model relations:
 * @property Hoteles $idHotel
 * @property TipoPago $idTipo
 * @property Cuenta $idCuenta
 * @property Users $idUser
 * @property OrdenesPagoDetalles[] $ordenesPagoDetalles
 */
class OrdenesPago extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return OrdenesPago the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{ordenes_pago}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_hotel, importe, id_tipo, id_user', 'required'),
			array('id_tipo, id_cuenta, no_referencia, id_user', 'numerical', 'integerOnly'=>true),
			array('importe', 'numerical'),
			array('id_hotel', 'length', 'max'=>10),
			array('estado', 'length', 'max'=>1),
			array('motivo', 'length', 'max'=>255),
			array('fecha, facturacion', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_orden_pago, id_hotel, importe, id_tipo, id_cuenta, no_referencia, id_user, fecha, estado', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idHotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),
			'idTipo' => array(self::BELONGS_TO, 'TipoPago', 'id_tipo'),
			'idCuenta' => array(self::BELONGS_TO, 'Cuenta', 'id_cuenta'),
			'idUser' => array(self::BELONGS_TO, 'Users', 'id_user'),
			'ordenesPagoDetalles' => array(self::HAS_MANY, 'OrdenesPagoDetalles', 'id_orden_pago'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_orden_pago' => 'Orden Pago',
			'id_hotel' => 'Hotel',
			'importe' => 'Importe',
			'id_tipo' => 'Tipo',
			'id_cuenta' => 'Cuenta',
			'no_referencia' => 'No Referencia',
			'id_user' => 'User',
			'fecha' => 'Fecha',
			'estado' => 'Estado',
			'facturacion' => 'Facturación',
			'motivo' => 'Motivo',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_orden_pago',$this->id_orden_pago);
		$criteria->compare('id_hotel',$this->id_hotel,true);
		$criteria->compare('importe',$this->importe);
		$criteria->compare('id_tipo',$this->id_tipo);
		$criteria->compare('id_cuenta',$this->id_cuenta);
		$criteria->compare('no_referencia',$this->no_referencia);
		$criteria->compare('id_user',$this->id_user);
		$criteria->compare('fecha',$this->fecha,true);
		$criteria->compare('estado',$this->estado,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}