<?php

/**
 * This is the model class for table "{{operaciones_tipo}}".
 *
 * The followings are the available columns in table '{{operaciones_tipo}}':
 * @property integer $id_operacion_tipo
 * @property string $tipo_operacion
 *
 * The followings are the available model relations:
 * @property OperacionesLog[] $operacionesLogs
 */
class OperacionesTipo extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return OperacionesTipo the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{operaciones_tipo}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('tipo_operacion', 'required'),
			array('tipo_operacion', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_operacion_tipo, tipo_operacion', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'operacionesLogs' => array(self::HAS_MANY, 'OperacionesLog', 'id_operacion_tipo'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_operacion_tipo' => 'Id Operacion Tipo',
			'tipo_operacion' => 'Tipo Operacion',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_operacion_tipo',$this->id_operacion_tipo);
		$criteria->compare('tipo_operacion',$this->tipo_operacion,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}