<?php

/**
 * This is the model class for table "{{min_noches}}".
 *
 * The followings are the available columns in table '{{min_noches}}':
 * @property integer $id
 * @property string $id_tarifa
 * @property string $fecha_inicio
 * @property string $fecha_final
 * @property string $id_tipo_habitacion
 * @property integer $minimo
 *
 * The followings are the available model relations:
 * @property TipoHabitaciones $idTipoHabitacion
 * @property Tarifa $idTarifa
 */
class MinNoches extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MinNoches the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{min_noches}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_tarifa, fecha_inicio, fecha_final, id_tipo_habitacion, minimo', 'required'),
			array('minimo', 'numerical', 'integerOnly'=>true),
			array('id_tarifa, id_tipo_habitacion', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, id_tarifa, fecha_inicio, fecha_final, id_tipo_habitacion, minimo', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idTipoHabitacion' => array(self::BELONGS_TO, 'TipoHabitaciones', 'id_tipo_habitacion'),
			'idTarifa' => array(self::BELONGS_TO, 'Tarifa', 'id_tarifa'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'id_tarifa' => 'Id Tarifa',
			'fecha_inicio' => 'Fecha Inicio',
			'fecha_final' => 'Fecha Final',
			'id_tipo_habitacion' => 'Tipo de Habitación',
			'minimo' => 'Mínimo',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('id_tarifa',$this->id_tarifa,true);
		$criteria->compare('fecha_inicio',$this->fecha_inicio,true);
		$criteria->compare('fecha_final',$this->fecha_final,true);
		$criteria->compare('id_tipo_habitacion',$this->id_tipo_habitacion,true);
		$criteria->compare('minimo',$this->minimo);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}