<?php

/**
 * This is the model class for table "{{mega_grupos}}".
 *
 * The followings are the available columns in table '{{mega_grupos}}':
 * @property integer $id_mega
 * @property string $titulo
 * @property string $fecha_inicio
 * @property string $fecha_final
 * @property string $log
 * @property integer $id_usuario
 * @property integer $estatus
 * @property string $observaciones
 *
 * The followings are the available model relations:
 * @property MegaGruposBloqueos[] $megaGruposBloqueoses
 */
class MegaGrupos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MegaGrupos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mega_grupos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('fecha_inicio, fecha_final, id_usuario, titulo', 'required'),
			array('id_usuario, estatus, visible', 'numerical', 'integerOnly'=>true),
			array('titulo', 'length', 'max'=>155),
			array('observaciones', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_mega, titulo, id_hotel, id_agencia, fecha_inicio, fecha_final, log, id_usuario, estatus, observaciones', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'megaGruposBloqueoses' => array(self::HAS_MANY, 'MegaGruposBloqueos', 'id_mega'),
			'idUsuario' => array(self::BELONGS_TO, 'Usuarios', 'id_usuario')
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_mega' => 'Id Mega',
			'titulo' => 'Titulo',
			'fecha_inicio' => 'Fecha Inicio',
			'fecha_final' => 'Fecha Final',
			'log' => 'Log',
			'id_usuario' => 'Id Usuario',
			'estatus' => 'Estatus',
			'visible' => 'Visibilidad',
			'observaciones' => 'Observaciones',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_mega',$this->id_mega);
		$criteria->compare('titulo',$this->titulo,true);
		$criteria->compare('fecha_inicio',$this->fecha_inicio,true);
		$criteria->compare('fecha_final',$this->fecha_final,true);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('id_usuario',$this->id_usuario);
		$criteria->compare('estatus',$this->estatus);
		$criteria->compare('observaciones',$this->observaciones,true);
		$criteria->condition='t.estatus=0';
	   	$criteria->with=array('megaGruposBloqueoses.idBloqueo','megaGruposBloqueoses.idBloqueo.idTarifa');

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}