<?php

/**
 * This is the model class for table "{{hoteles_destacados}}".
 *
 * The followings are the available columns in table '{{hoteles_destacados}}':
 * @property string $id_hoteles_destacados
 * @property string $id_hotel
 * @property integer $estatus
 * @property string $fecha_inicio
 * @property string $fecha_final
 */
class HotelesDestacados extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return HotelesDestacados the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hoteles_destacados}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_hotel', 'required'),
			array('estatus', 'numerical', 'integerOnly'=>true),
			array('id_hotel', 'length', 'max'=>11),
			array('fecha_inicio, fecha_final', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_hoteles_destacados, id_hotel, estatus, fecha_inicio, fecha_final', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idHotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_hoteles_destacados' => 'Id Hoteles Destacados',
			'id_hotel' => 'Id Hotel',
			'estatus' => 'Estatus',
			'fecha_inicio' => 'Fecha Inicio',
			'fecha_final' => 'Fecha Final',
			
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_hoteles_destacados',$this->id_hoteles_destacados,true);
		$criteria->compare('id_hotel',$this->id_hotel,true);
		$criteria->compare('estatus',$this->estatus);
		$criteria->compare('fecha_inicio',$this->fecha_inicio,true);
		$criteria->compare('fecha_final',$this->fecha_final,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}