<?php

/**
 * This is the model class for table "{{hoteles_beneficios}}".
 *
 * The followings are the available columns in table '{{hoteles_beneficios}}':
 * @property integer $id_hotel_beneficios
 * @property string $id_hotel
 * @property string $beneficio
 * @property string $fecha_inicio
 * @property string $fecha_final
 * @property string $estancia_inicio
 * @property string $estancia_final
 * @property string $tipo
 * @property integer $estatus
 * @property string $log
 */
class HotelesBeneficios extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return HotelesBeneficios the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hoteles_beneficios}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_hotel, beneficio', 'required'),
			array('estatus', 'numerical', 'integerOnly'=>true),
			array('id_hotel', 'length', 'max'=>10),
            array('tipo', 'length', 'max'=>15),
			array('fecha_inicio, fecha_final, estancia_inicio, estancia_final', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_hotel_beneficios, id_hotel, beneficio, fecha_inicio, fecha_final, tipo, estatus', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_hotel_beneficios' => 'Id Hotel Beneficios',
			'id_hotel' => 'Id Hotel',
			'beneficio' => 'Beneficio',
			'fecha_inicio' => 'Fecha Inicio',
			'fecha_final' => 'Fecha Final',
			'estancia_inicio' => 'Estancia Inicio',
			'estancia_final' => 'Estancia Final',
            'tipo' => 'Tipo',
			'estatus' => 'Estatus',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_hotel_beneficios',$this->id_hotel_beneficios);
		$criteria->compare('id_hotel',$this->id_hotel,true);
		$criteria->compare('beneficio',$this->beneficio,true);
		$criteria->compare('fecha_inicio',$this->fecha_inicio,true);
		$criteria->compare('fecha_final',$this->fecha_final,true);
		$criteria->compare('estancia_inicio',$this->estancia_inicio,true);
		$criteria->compare('estancia_final',$this->estancia_final,true);
        $criteria->compare('tipo',$this->tipo,true);
		$criteria->compare('estatus',$this->estatus);
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}