<?php

/**
 * This is the model class for table "{{guests}}".
 *
 * The followings are the available columns in table '{{guests}}':
 * @property integer $id_guest
 * @property string $nombre_agencia
 * @property string $telefono
 * @property string $contacto
 * @property string $email
 *
 * The followings are the available model relations:
 * @property EventsGuests[] $eventsGuests
 */
class Guests extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Guests the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{guests}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('nombre_agencia, contacto', 'required'),
			array('nombre_agencia, contacto', 'length', 'max'=>100),
			array('telefono', 'length', 'max'=>20),
			array('email', 'length', 'max'=>50),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_guest, nombre_agencia, telefono, contacto, email', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'eventsGuests' => array(self::HAS_MANY, 'EventsGuests', 'id_invitado'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_guest' => 'Id Guest',
			'nombre_agencia' => 'Nombre Agencia',
			'telefono' => 'Telefono',
			'contacto' => 'Contacto',
			'email' => 'Email',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_guest',$this->id_guest);
		$criteria->compare('nombre_agencia',$this->nombre_agencia,true);
		$criteria->compare('telefono',$this->telefono,true);
		$criteria->compare('contacto',$this->contacto,true);
		$criteria->compare('email',$this->email,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}