<?php

/**
 * This is the model class for table "{{grupos_politicas_pagos_desglose}}".
 *
 * The followings are the available columns in table '{{grupos_politicas_pagos_desglose}}':
 * @property integer $id_politicas_pagos_desglose
 * @property integer $id_politicas_pagos
 * @property string $descripcion_pago
 * @property string $fecha
 * @property double $importe
 * @property string $observaciones
 *
 * The followings are the available model relations:
 * @property GruposPoliticasPagos $idPoliticasPagos
 */
class GruposPoliticasPagosDesglose extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return GruposPoliticasPagosDesglose the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{grupos_politicas_pagos_desglose}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules() 
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_politicas_pagos, descripcion_pago, fecha', 'required'),
			array('id_politicas_pagos, pagado', 'numerical', 'integerOnly'=>true),
			array('descripcion_pago', 'length', 'max'=>30),
			array('importe','numerical', 'integerOnly'=>false),
			array('observaciones', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_politicas_pagos_desglose, id_politicas_pagos,descripcion_pago, fecha, importe, observaciones', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idPoliticasPagos' => array(self::BELONGS_TO, 'GruposPoliticasPagos', 'id_politicas_pagos'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_politicas_pagos_desglose' => 'Id Políticas Pagos Desglose',
			'id_politicas_pagos' => 'Id Políticas Pagos',
			'descripcion_pago' => 'Descripción Pago',
			'fecha' => 'Fecha',
			'importe' => 'Importe',
			'observaciones' => 'Observaciones',
			'pagado' => 'Pagado',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_politicas_pagos_desglose',$this->id_politicas_pagos_desglose);
		$criteria->compare('id_politicas_pagos',$this->id_politicas_pagos);
        $criteria->compare('descripcion_pago',$this->descripcion_pago,true);
		$criteria->compare('fecha',$this->fecha,true);
		$criteria->compare('importe',$this->importe);
		$criteria->compare('observaciones',$this->observaciones,true);
		$criteria->compare('pagado',$this->pagado);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>array(
                    'defaultOrder'=>'fecha ASC',
                ),
		));
	}
}