<?php

/**
 * This is the model class for table "{{grupos_cotizaciones}}".
 *
 * The followings are the available columns in table '{{grupos_cotizaciones}}':
 * @property integer $id_grupos_cotizaciones
 * @property string $id_hotel
 * @property string $id_usuario
 * @property integer $id_agencia
 * @property string $id_tarifa
 * @property integer $estatus_hotel
 * @property integer $estatus_agencia
 * @property integer $id_tipo_habitacion
 * @property integer $num_habitaciones
 * @property string $comentario
 * @property string $detalles_cotizacion
 * @property double $importe
 * @property string $fecha_respuesta
 * @property string $estatus
 * @property string $id_grupo
 * @property string $fecha_solicitud
 * @property string $fecha_entrada
 * @property string $fecha_salida
 * @property string $id_grupos_tipos
 *
 * The followings are the available model relations:
 * @property Agencias $idAgencia
 * @property Usuarios $idUsuario
 * @property Hoteles $idHotel
 * @property Tarifa $idTarifa
 * @property Bloqueos $idGrupo
 * @property GruposTipos $idGruposTipos
 */
class GruposCotizaciones extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return GruposCotizaciones the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{grupos_cotizaciones}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_hotel, id_usuario, id_agencia, id_tarifa, estatus_hotel, id_tipo_habitacion, num_habitaciones, comentario, fecha_solicitud, fecha_entrada, fecha_salida', 'required'),
			array('id_agencia, estatus_hotel, id_tipo_habitacion,estatus_agencia, num_habitaciones', 'numerical', 'integerOnly'=>true),
			array('importe', 'numerical'),
			array('id_hotel, id_tarifa, id_grupo', 'length', 'max'=>11),
			array('id_usuario, id_grupos_tipos', 'length', 'max'=>10),
			array('estatus', 'length', 'max'=>15),
			array('detalles_cotizacion, fecha_respuesta', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_grupos_cotizaciones, id_hotel, id_usuario, id_agencia, id_tarifa, estatus_hotel, estatus_agencia, id_tipo_habitacion, num_habitaciones, comentario, detalles_cotizacion, importe, fecha_respuesta, estatus, id_grupo, fecha_solicitud, fecha_entrada, fecha_salida, id_grupos_tipos', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idAgencia' => array(self::BELONGS_TO, 'Agencias', 'id_agencia'),
			'idUsuario' => array(self::BELONGS_TO, 'Usuarios', 'id_usuario'),
			'idHotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),
			'idTarifa' => array(self::BELONGS_TO, 'Tarifa', 'id_tarifa'),
			'idGrupo' => array(self::BELONGS_TO, 'Bloqueos', 'id_grupo'),
			'idGruposTipos' => array(self::BELONGS_TO, 'GruposTipos', 'id_grupos_tipos'),
			'idTipoHabitacion' => array(self::BELONGS_TO, 'TipoHabitaciones', 'id_tipo_habitacion'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(			
			'id_grupos_cotizaciones' => 'Id Grupos Cotizaciones',
			'id_hotel' => 'Hotel',
			'id_usuario' => 'Usuario',
			'id_agencia' => 'Agencia',
			'id_tarifa' => 'Tarifa',
			'estatus_hotel' => 'Estatus Hotel',
			'estatus_agencia' => 'Estatus Agencia',
			'id_tipo_habitacion' => 'Id Tipo Habitacion',
			'num_habitaciones' => 'No. Habitaciones',
			'comentario' => 'Observaciones',
			'detalles_cotizacion' => 'Detalles',
			'importe' => 'Importe',
			'fecha_respuesta' => 'Fecha Respuesta',
			'estatus' => 'Estatus',
			'id_grupo' => 'Grupo',
			'fecha_solicitud' => 'Fecha Solicitud',
			'fecha_entrada' => 'Fecha Entrada',
			'fecha_salida' => 'Fecha Salida',
			'id_grupos_tipos' => 'Tipo grupo',

		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_grupos_cotizaciones',$this->id_grupos_cotizaciones);
		$criteria->compare('id_hotel',$this->id_hotel,true);
		$criteria->compare('id_usuario',$this->id_usuario,true);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('id_tarifa',$this->id_tarifa,true);
		$criteria->compare('estatus_hotel',$this->estatus_hotel);
		$criteria->compare('estatus_agencia',$this->estatus_agencia);
		$criteria->compare('id_tipo_habitacion',$this->id_tipo_habitacion);
		$criteria->compare('num_habitaciones',$this->num_habitaciones);
		$criteria->compare('comentario',$this->comentario,true);
		$criteria->compare('detalles_cotizacion',$this->detalles_cotizacion,true);
		$criteria->compare('importe',$this->importe);
		$criteria->compare('fecha_respuesta',$this->fecha_respuesta,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('id_grupo',$this->id_grupo,true);
		$criteria->compare('fecha_solicitud',$this->fecha_solicitud,true);
		$criteria->compare('fecha_entrada',$this->fecha_entrada,true);
		$criteria->compare('fecha_salida',$this->fecha_salida,true);
		$criteria->compare('id_grupos_tipos',$this->id_grupos_tipos,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}