<?php

/**
 * This is the model class for table "{{files_relacionados}}".
 *
 * The followings are the available columns in table '{{files_relacionados}}':
 * @property integer $id
 * @property string $modelo
 * @property integer $id_modelo
 * @property integer $id_file
 *
 * The followings are the available model relations:
 * @property Files $idFile
 */
class FilesRelacionados extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return FilesRelacionados the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{files_relacionados}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('modelo, id_modelo, id_file', 'required'),
			array('id_modelo, id_file', 'numerical', 'integerOnly'=>true),
			array('modelo', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, modelo, id_modelo, id_file', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idFile' => array(self::BELONGS_TO, 'Files', 'id_file'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'modelo' => 'Modelo',
			'id_modelo' => 'Id Modelo',
			'id_file' => 'Id File',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('modelo',$this->modelo,true);
		$criteria->compare('id_modelo',$this->id_modelo);
		$criteria->compare('id_file',$this->id_file);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}